package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.business.response.ImageCodeResponse;
import org.wxz.business.service.ImageCodeService;

import javax.annotation.Resource;

@Api(value = "ImageCodeController", tags = "图片验证码相关接口")
@Slf4j
@RestController
public class ImageCodeController {
    
    @Resource
    private ImageCodeService imageCodeService;
    
    @ApiOperation("图片验证码")
    @GetMapping("imageCode")
    public ResponseModel<ImageCodeResponse> imageCode(ResponseModel<ImageCodeResponse> responseModel) {
        imageCodeService.imageCode(responseModel);
        return responseModel;
    }
}