package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.business.response.PositionResponse;
import org.wxz.business.service.PositionService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Api(value = "PositionController", tags = "定位相关接口")
@Slf4j
@RestController
public class PositionController {
    
    @Resource
    private PositionService positionService;
    
    @ApiOperation("定位（历史遗留问题，后期建议都走鉴权）")
    @GetMapping({"position", "base/position"})
    public ResponseModel<PositionResponse> position(ResponseModel<PositionResponse> responseModel, HttpServletRequest request) {
        positionService.position(responseModel, request);
        return responseModel;
    }
}