package org.wxz.base.config.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.wxz.base.config.filter.callback.TokenFilterCallback;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
public class TokenFilter implements Filter, Ordered {
    
    @Value("${system.filter.order.token:3}")
    private int order;
    
    // 千万不要用 @Resource 否则要死的心都有
    @Autowired
    private TokenFilterCallback tokenFilterCallback;
    
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        
    }
    
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        if (tokenFilterCallback.service(request, response)) {
            filterChain.doFilter(request, response);
        }
    }
    
    @Override
    public void destroy() {
        
    }
    
    @Override
    public int getOrder() {
        return order;
    }
}