package org.wxz.business.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Date;

@Slf4j
@ApiModel(value = "BaseArea", description = "基础：行政区实体类")
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
public class BaseArea implements Serializable {
    
    @ApiModelProperty("主键")
    @TableId
    private String id;
    
    @ApiModelProperty("父主键")
    private String pId;
    
    @ApiModelProperty("地名")
    private String name;
    
    @ApiModelProperty("创建时间")
    private Date createTime;
    
    @ApiModelProperty("状态")
    @TableField("`status`")
    private Boolean status;
    
}