package org.wxz.business.service.impl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.wxz.base.config.path.ConfigPathExt;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.response.ImageCodeResponse;
import org.wxz.business.service.ImageCodeService;
import org.wxz.tools.oracle.io.file.constant.FileFormat;
import org.wxz.tools.oracle.io.file.image.callback.impl.ImageCodeFileCallback;

import javax.annotation.Resource;
import java.io.File;

@Slf4j
@Service
public class ImageCodeServiceImpl implements ImageCodeService {
    
    @Resource
    private ConfigPathExt configPathExt;
    
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;
    
    @Override
    public void imageCode(ResponseModel<ImageCodeResponse> responseModel) {
        ImageCodeResponse imageCodeResponse = new ImageCodeResponse();
        String fileName = imageCodeResponse.getImgId() + "." + FileFormat.PNG;
        imageCodeResponse.setImgSrc(configPathExt.getImageCodeRelativePath() + "/" + fileName);
        configRedisValueExt.setImageCode(imageCodeResponse.getImgId(), org.wxz.tools.oracle.io.file.image.util.ImageCodeUtil.draw(new ImageCodeFileCallback(new File(configPathExt.getImageCodeAbsolutePath(), fileName))).toString());
        ResponseUtil.executeSuccess(responseModel, imageCodeResponse);
    }
}