package org.wxz.business.service.impl;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.service.LogoutService;

import javax.annotation.Resource;

@Slf4j
@Service
public class LogoutServiceImpl implements LogoutService {
    
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;
    
    @Override
    public void logout(ResponseModel<Boolean> responseModel, String token) {
        configRedisValueExt.delToken(token);
        ResponseUtil.executeSuccess(responseModel, true);
    }
}