/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.base.config.filter;

import java.io.Serializable;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.wxz.base.config.filter.IdempotentFilter;
import org.wxz.tools.oracle.type.util.StringUtil;

@Configuration
@ConditionalOnProperty(prefix="base", name={"ConfigIdempotentFilter"}, havingValue="open", matchIfMissing=true)
public class ConfigIdempotentFilter
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConfigIdempotentFilter.class);
    @Value(value="${system.filter.order.idempotent:4}")
    private int order;

    @Bean
    public IdempotentFilter idempotentFilter() {
        return new IdempotentFilter();
    }

    @Bean
    public FilterRegistrationBean<Filter> idempotentFilterRegistrationBean() {
        FilterRegistrationBean idempotentFilterRegistrationBean = new FilterRegistrationBean();
        idempotentFilterRegistrationBean.setFilter((Filter)new DelegatingFilterProxy(StringUtil.nameVariable(IdempotentFilter.class)));
        idempotentFilterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        idempotentFilterRegistrationBean.setOrder(this.order);
        log.info("==========\u6ce8\u518c 'IdempotentFilter' \u6210\u529f==========");
        return idempotentFilterRegistrationBean;
    }
}

