/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.base.config.filter;

import java.io.Serializable;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.wxz.base.config.filter.TokenFilter;
import org.wxz.tools.oracle.type.util.StringUtil;

@Configuration
@ConditionalOnProperty(prefix="base", name={"ConfigTokenFilter"}, havingValue="open", matchIfMissing=true)
public class ConfigTokenFilter
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ConfigTokenFilter.class);
    @Value(value="${system.filter.order.token:3}")
    private int order;

    @Bean
    public TokenFilter tokenFilter() {
        return new TokenFilter();
    }

    @Bean
    public FilterRegistrationBean<Filter> tokenFilterRegistrationBean() {
        FilterRegistrationBean tokenFilterRegistrationBean = new FilterRegistrationBean();
        tokenFilterRegistrationBean.setFilter((Filter)new DelegatingFilterProxy(StringUtil.nameVariable(TokenFilter.class)));
        tokenFilterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        tokenFilterRegistrationBean.setOrder(this.order);
        log.info("==========\u6ce8\u518c 'TokenFilter' \u6210\u529f==========");
        return tokenFilterRegistrationBean;
    }
}

