/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.base.config.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.wxz.base.config.filter.mode.Message;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.config.token.ConfigToken;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.servlet.util.FilterUtil;
import org.wxz.tools.oracle.servlet.util.HttpServletRequestWrapperUtil;

public class IdempotentFilter
implements Filter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(IdempotentFilter.class);
    @Value(value="${system.filter.order.idempotent:4}")
    private int order;
    @Value(value="${system.sleep.url:${system.index.url}}")
    private String url;
    @Value(value="${system.safety.idempotent.white-list:}")
    private String whiteList;
    @Autowired
    private ConfigToken configToken;
    @Autowired
    private ConfigRedisValueExt<String, String, Message> configRedisValueExt;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean stop = true;
        for (String path : this.whiteList.split(",")) {
            if (!request.getRequestURI().contains(path)) continue;
            stop = false;
            break;
        }
        if (stop) {
            Message message = new Message(request.getRemoteAddr(), request.getRequestURI(), this.configToken.getToken(request), request.getParameterMap());
            HttpServletRequestWrapperUtil httpServletRequestWrapperUtil = null;
            try {
                httpServletRequestWrapperUtil = new HttpServletRequestWrapperUtil(request);
                message.setPayload(httpServletRequestWrapperUtil.getBodyString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (FilterUtil.filter((boolean)NullUtil.isNotNull((Object)this.configRedisValueExt.getMessage(message)), (HttpServletRequest)request, (HttpServletResponse)response, (String)this.url, (Object)ResponseUtil.initFrequentRequestResponseModel(), () -> this.configRedisValueExt.setMessage(message))) {
                filterChain.doFilter((ServletRequest)(NullUtil.isNull((Object)httpServletRequestWrapperUtil) ? request : httpServletRequestWrapperUtil), (ServletResponse)response);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return this.order;
    }
}

