/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.base.config.filter;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.config.token.ConfigToken;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.servlet.util.FilterUtil;
import org.wxz.tools.oracle.type.util.BooleanUtil;

public class TokenFilter
implements Filter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TokenFilter.class);
    @Value(value="${system.filter.order.token:3}")
    private int order;
    @Value(value="${system.safety.black-list:/pt/,/base/,/business/,/logout,/base/logout,/position,/base/position,/upload/files,/base/upload/files,/upload/file,/base/upload/file}")
    private String blackList;
    @Value(value="${system.safety.white-list:/pb/,/logout,/base/logout,/position,/base/position,/upload/files,/base/upload/files,/upload/file,/base/upload/file,/base/area/listByPId,/base/dept/findAll}")
    private String whiteList;
    @Value(value="${system.index.url}")
    private String url;
    @Resource
    private ConfigToken configToken;
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean stop = false;
        for (String path : this.blackList.split(",")) {
            if (!request.getRequestURI().contains(path)) continue;
            stop = true;
            break;
        }
        for (String path : this.whiteList.split(",")) {
            if (!request.getRequestURI().contains(path)) continue;
            stop = false;
            break;
        }
        if (BooleanUtil.isFalse((boolean)stop) || FilterUtil.filter((boolean)EmptyUtil.isNull((String)this.configRedisValueExt.getToken(this.configToken.getToken(request))), (HttpServletRequest)request, (HttpServletResponse)response, (String)this.url, (Object)ResponseUtil.initIllegalTokenResponseModel())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    public int getOrder() {
        return this.order;
    }
}

