/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.base.config.redis.value;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.wxz.base.config.filter.mode.Message;
import org.wxz.base.config.redis.key.ConfigRedisKeyExt;
import org.wxz.base.config.redis.model.TokenForUser;
import org.wxz.base.config.redis.redistemplate.FastJsonRedisTemplate;
import org.wxz.base.config.redis.value.ConfigRedisValue;
import org.wxz.tools.alibaba.fastjson.util.FastJsonUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;

@RefreshScope
@Configuration
public class ConfigRedisValueExt<K, HK, HV>
extends ConfigRedisValue<K, HK, HV> {
    private static final Logger log = LoggerFactory.getLogger(ConfigRedisValueExt.class);
    @Resource
    protected StringRedisTemplate stringRedisTemplate;
    @Resource
    protected FastJsonRedisTemplate<K, HK, HV> fastJsonRedisTemplate;
    @Value(value="${system.timeout.token:1440}")
    private long tokenTimeout;
    @Value(value="${system.timeout.image-code:5}")
    private long imageCodeTimeout;
    @Value(value="${system.timeout.idempotent.ip:-1}")
    private long ipIdempotentTimeout;
    @Value(value="${system.timeout.idempotent.token:1000}")
    private long tokenIdempotentTimeout;
    @Resource
    private ConfigRedisKeyExt configRedisKeyExt;

    public void setTokenForUser(String token, TokenForUser user) {
        this.setTokenForObject(token, user);
    }

    public void setTokenForObject(String token, Object user) {
        this.setToken(token, FastJsonUtil.toJson((Object)user));
    }

    public void setToken(String token, String userId) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.configRedisKeyExt.getToken() + token), (Object)userId, this.tokenTimeout, TimeUnit.MINUTES);
    }

    public TokenForUser getTokenForUser(String token) {
        return this.getTokenForObject(token, TokenForUser.class);
    }

    public <T> T getTokenForObject(String token, Class<T> clazz) {
        return (T)FastJsonUtil.toClass((String)this.getToken(token), clazz);
    }

    public String getToken(String token) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.configRedisKeyExt.getToken() + token));
    }

    public void delToken(String token) {
        this.stringRedisTemplate.delete((Object)(this.configRedisKeyExt.getToken() + token));
    }

    public void flushToken() {
        for (String key : this.stringRedisTemplate.keys((Object)(this.configRedisKeyExt.getToken() + "*"))) {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    public void setImageCode(String uuid, String imageCode) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.configRedisKeyExt.getImageCode() + uuid), (Object)imageCode, this.imageCodeTimeout, TimeUnit.MINUTES);
    }

    public String getImageCode(String uuid) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.configRedisKeyExt.getImageCode() + uuid));
    }

    public void delImageCode(String uuid) {
        this.stringRedisTemplate.delete((Object)(this.configRedisKeyExt.getImageCode() + uuid));
    }

    public void flushImageCode() {
        for (String key : this.stringRedisTemplate.keys((Object)(this.configRedisKeyExt.getImageCode() + "*"))) {
            this.stringRedisTemplate.delete((Object)key);
        }
    }

    public Message getMessage(Message message) {
        return (Message)this.fastJsonRedisTemplate.opsForValue().get((Object)(this.configRedisKeyExt.getIdempotent() + message.getId()));
    }

    public void setMessage(Message message) {
        long idempotentTimeout;
        long l = idempotentTimeout = EmptyUtil.isNull((String)message.getToken()) ? this.ipIdempotentTimeout : this.tokenIdempotentTimeout;
        if (idempotentTimeout > 0L) {
            this.fastJsonRedisTemplate.opsForValue().set((Object)(this.configRedisKeyExt.getIdempotent() + message.getId()), (Object)message, idempotentTimeout, TimeUnit.MILLISECONDS);
        }
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public FastJsonRedisTemplate<K, HK, HV> getFastJsonRedisTemplate() {
        return this.fastJsonRedisTemplate;
    }

    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    public long getImageCodeTimeout() {
        return this.imageCodeTimeout;
    }

    public long getIpIdempotentTimeout() {
        return this.ipIdempotentTimeout;
    }

    public long getTokenIdempotentTimeout() {
        return this.tokenIdempotentTimeout;
    }

    public ConfigRedisKeyExt getConfigRedisKeyExt() {
        return this.configRedisKeyExt;
    }
}

