/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import java.io.File;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.wxz.base.config.path.ConfigPathExt;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.response.ImageCodeResponse;
import org.wxz.business.service.ImageCodeService;
import org.wxz.tools.oracle.io.file.image.callback.ImageCodeCallback;
import org.wxz.tools.oracle.io.file.image.callback.impl.ImageCodeFileCallback;
import org.wxz.tools.oracle.io.file.image.util.ImageCodeUtil;

@Service
public class ImageCodeServiceImpl
implements ImageCodeService {
    private static final Logger log = LoggerFactory.getLogger(ImageCodeServiceImpl.class);
    @Resource
    private ConfigPathExt configPathExt;
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;

    @Override
    public void imageCode(ResponseModel<ImageCodeResponse> responseModel) {
        ImageCodeResponse imageCodeResponse = new ImageCodeResponse();
        String fileName = imageCodeResponse.getImgId() + "." + "png";
        imageCodeResponse.setImgSrc(this.configPathExt.getImageCodeRelativePath() + "/" + fileName);
        this.configRedisValueExt.setImageCode(imageCodeResponse.getImgId(), ImageCodeUtil.draw((ImageCodeCallback)new ImageCodeFileCallback(new File(this.configPathExt.getImageCodeAbsolutePath(), fileName))).toString());
        ResponseUtil.executeSuccess(responseModel, (Object)imageCodeResponse);
    }
}

