/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.wxz.base.config.path.ConfigPathExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.service.UploadService;
import org.wxz.tools.oracle.io.file.util.FileNameUtil;
import org.wxz.tools.oracle.io.file.util.FileWriteUtil;

@Service
public class UploadServiceImpl
implements UploadService {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    @Resource
    private ConfigPathExt configPathExt;

    @Override
    public void files(ResponseModel<List<String>> responseModel, MultipartFile[] multipartFiles) {
        ArrayList<String> fileUrlList = new ArrayList<String>();
        for (MultipartFile multipartFile : multipartFiles) {
            fileUrlList.add(this.upload(multipartFile));
        }
        ResponseUtil.executeSuccess(responseModel, fileUrlList);
    }

    @Override
    public void file(ResponseModel<String> responseModel, MultipartFile multipartFile) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.upload(multipartFile));
    }

    private String upload(MultipartFile multipartFile) {
        String md5Name = FileNameUtil.md5Name((MultipartFile)multipartFile);
        FileWriteUtil.write((MultipartFile)multipartFile, (String)this.configPathExt.getAbsolutePath(), (String)md5Name);
        return this.configPathExt.getRelativePath() + "/" + md5Name;
    }
}

