/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.model.BaseDict;
import org.wxz.business.param.BaseDictAddParam;
import org.wxz.business.param.BaseDictEditParam;
import org.wxz.business.param.BaseDictFindAllParam;
import org.wxz.business.param.BaseDictStatusParam;
import org.wxz.business.service.BaseDictService;
import org.wxz.tools.apache.spring.bean.SpringBeanUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;

@Api(value="BaseDictController", tags={"\u57fa\u7840\uff1a\u5b57\u5178\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"base/dict"})
public class BaseDictController {
    @Resource
    private BaseDictService baseDictService;

    @ApiOperation(value="\u5217\u8868")
    @PostMapping(value={"findAll"})
    public ResponseModel<List<BaseDict>> findAll(ResponseModel<List<BaseDict>> responseModel, @Valid @RequestBody BaseDictFindAllParam findAllParam) {
        this.baseDictService.findAll(responseModel, findAllParam);
        return responseModel;
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"add"})
    public ResponseModel<Boolean> add(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDictAddParam addParam) {
        this.baseDictService.add(responseModel, (BaseDict)SpringBeanUtil.copy((Object)addParam, BaseDict.class));
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u627e")
    @GetMapping(value={"findById/{id}"})
    public ResponseModel<BaseDict> findById(ResponseModel<BaseDict> responseModel, @PathVariable String id) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseDictService.getById((Serializable)((Object)id)));
        return responseModel;
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"edit"})
    public ResponseModel<Boolean> edit(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDictEditParam editParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseDictService.updateById(SpringBeanUtil.copy((Object)editParam, BaseDict.class)));
        return responseModel;
    }

    @ApiOperation(value="\u72b6\u6001")
    @PostMapping(value={"status"})
    public ResponseModel<Boolean> status(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDictStatusParam statusParam) {
        this.baseDictService.status(responseModel, statusParam);
        return responseModel;
    }

    @ApiOperation(value="\u5b50\u4ee3-\u7236\u540d\u79f0")
    @GetMapping(value={"findChildrenByName/{name}"})
    public ResponseModel<List<BaseDict>> findChildrenByName(ResponseModel<List<BaseDict>> responseModel, @PathVariable String name) {
        this.baseDictService.findChildrenByName(responseModel, name);
        return responseModel;
    }

    @ApiOperation(value="\u5b50\u4ee3-\u7236\u4e3b\u952e")
    @GetMapping(value={"findChildrenByPid/{pid}"})
    public ResponseModel<List<BaseDict>> findChildrenByPid(ResponseModel<List<BaseDict>> responseModel, @PathVariable String pid) {
        this.baseDictService.findChildrenByPid(responseModel, pid);
        return responseModel;
    }

    @ApiOperation(value="\u82f1\u6587\u540d+\u72b6\u6001\uff1a\u67e5\u627e")
    @GetMapping(value={"findByName/{name}", "findByName/{name}/{status}"})
    public ResponseModel<BaseDict> findByName(ResponseModel<BaseDict> responseModel, @PathVariable String name, @PathVariable(required=false) Boolean status) {
        this.baseDictService.findByNameAndStatus(responseModel, name, NullUtil.isNull((Object)status) || status != false);
        return responseModel;
    }
}

