/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.page.PageResponse;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.dto.query.BaseUserRelaDept;
import org.wxz.business.model.BaseUser;
import org.wxz.business.param.BaseUserAddParam;
import org.wxz.business.param.BaseUserEditForAdminParam;
import org.wxz.business.param.BaseUserEditForMyselfParam;
import org.wxz.business.param.BaseUserModifyLogoParam;
import org.wxz.business.param.BaseUserModifyPasswordParam;
import org.wxz.business.param.BaseUserPageParam;
import org.wxz.business.param.BaseUserResetPasswordParam;
import org.wxz.business.param.BaseUserStatusParam;
import org.wxz.business.response.BaseUserFindByIdContainsDeptResponse;
import org.wxz.business.response.BaseUserFindByIdContainsRolesAndDeptResponse;
import org.wxz.business.response.BaseUserPageResponse;
import org.wxz.business.service.BaseUserService;
import org.wxz.tools.apache.spring.bean.SpringBeanUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;

@Api(value="BaseUserController", tags={"\u57fa\u7840\uff1a\u7528\u6237\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"base/user"})
public class BaseUserController {
    @Resource
    private BaseUserService baseUserService;
    @Resource
    private ConfigRedisValueExt<String, String> configRedisValueExt;

    @ApiOperation(value="\u5206\u9875")
    @PostMapping(value={"page"})
    public ResponseModel<PageResponse<BaseUserPageResponse>> page(ResponseModel<PageResponse<BaseUserPageResponse>> responseModel, Page<BaseUserRelaDept> page, @Valid @RequestBody BaseUserPageParam pageParam, @RequestHeader(value="token") String token) {
        this.baseUserService.page(responseModel, page, pageParam, this.configRedisValueExt.getToken(token));
        return responseModel;
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"add"})
    public ResponseModel<Boolean> add(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserAddParam addParam) {
        this.baseUserService.add(responseModel, addParam);
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u627e\uff1a\u57fa\u7840\u6570\u636e")
    @GetMapping(value={"findByIdContainsNothing", "findByIdContainsNothing/{id}"})
    public ResponseModel<BaseUser> findByIdContainsNothing(ResponseModel<BaseUser> responseModel, @PathVariable(required=false) String id, @RequestHeader(value="token") String token) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseUserService.getById((Serializable)((Object)(EmptyUtil.isNotNull((String)id) ? id : this.configRedisValueExt.getToken(token)))));
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u627e\uff1a\u5305\u542b\u89d2\u8272\u3001\u90e8\u95e8")
    @GetMapping(value={"findById/{id}", "findByIdContainsRolesAndDept/{id}"})
    public ResponseModel<BaseUserFindByIdContainsRolesAndDeptResponse> findByIdContainsRolesAndDept(ResponseModel<BaseUserFindByIdContainsRolesAndDeptResponse> responseModel, @PathVariable(required=false) String id, @RequestHeader(value="token") String token) {
        this.baseUserService.findByIdContainsRolesAndDept(responseModel, EmptyUtil.isNotNull((String)id) ? id : this.configRedisValueExt.getToken(token));
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u627e\uff1a\u5305\u542b\u90e8\u95e8")
    @GetMapping(value={"findByIdContainsDept", "findByIdContainsDept/{id}"})
    public ResponseModel<BaseUserFindByIdContainsDeptResponse> findByIdContainsDept(ResponseModel<BaseUserFindByIdContainsDeptResponse> responseModel, @PathVariable(required=false) String id, @RequestHeader(value="token") String token) {
        this.baseUserService.findByIdContainsDept(responseModel, EmptyUtil.isNotNull((String)id) ? id : this.configRedisValueExt.getToken(token));
        return responseModel;
    }

    @ApiOperation(value="\u7f16\u8f91\uff1a\u7ba1\u7406\u5458")
    @PostMapping(value={"edit", "edit/for/admin", "editForAdmin"})
    public ResponseModel<Boolean> editForAdmin(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserEditForAdminParam editForAdminParam) {
        this.baseUserService.edit(responseModel, editForAdminParam);
        return responseModel;
    }

    @ApiOperation(value="\u7f16\u8f91\uff1a\u6211\u81ea\u5df1")
    @PostMapping(value={"edit/for/myself", "editForMyself"})
    public ResponseModel<Boolean> editForMyself(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserEditForMyselfParam editForMyselfParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseUserService.updateById(SpringBeanUtil.copy((Object)editForMyselfParam, BaseUser.class)));
        return responseModel;
    }

    @ApiOperation(value="\u72b6\u6001")
    @PostMapping(value={"status"})
    public ResponseModel<Boolean> status(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserStatusParam statusParam) {
        this.baseUserService.status(responseModel, statusParam);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"findAll", "findAll/{status}"})
    public ResponseModel<List<BaseUser>> findAll(ResponseModel<List<BaseUser>> responseModel, @PathVariable(required=false) Boolean status) {
        this.baseUserService.findAll(responseModel, NullUtil.isNull((Object)status) || status != false);
        return responseModel;
    }

    @ApiOperation(value="\u4fee\u6539\u5934\u50cf")
    @PostMapping(value={"modify/logo", "modifyLogo"})
    public ResponseModel<Boolean> modifyLogo(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserModifyLogoParam modifyLogoParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseUserService.updateById(new BaseUser(modifyLogoParam.getId(), modifyLogoParam.getLogoUrl())));
        return responseModel;
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"modify/password", "modifyPassword"})
    public ResponseModel<Boolean> modifyPassword(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserModifyPasswordParam modifyPasswordParam) {
        this.baseUserService.modifyPassword(responseModel, modifyPasswordParam);
        return responseModel;
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"reset/password", "resetPassword"})
    public ResponseModel<Boolean> resetPassword(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseUserResetPasswordParam resetPasswordParam) {
        this.baseUserService.resetPassword(responseModel, resetPasswordParam);
        return responseModel;
    }
}

