/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.mapper.BaseDeptMapper;
import org.wxz.business.model.BaseDept;
import org.wxz.business.param.BaseDeptAddParam;
import org.wxz.business.param.BaseDeptEditParam;
import org.wxz.business.param.BaseDeptFindAllByRoleParam;
import org.wxz.business.param.BaseDeptFindAllParam;
import org.wxz.business.param.BaseDeptStatusParam;
import org.wxz.business.service.BaseDeptService;
import org.wxz.business.service.BaseRoleService;
import org.wxz.tools.apache.spring.bean.SpringBeanUtil;
import org.wxz.tools.oracle.collection.util.ListUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.type.util.StringUtil;

@Service
public class BaseDeptServiceImpl
extends ServiceImpl<BaseDeptMapper, BaseDept>
implements BaseDeptService {
    @Resource
    private ConfigRedisValueExt<String, String> configRedisValueExt;
    @Resource
    private BaseRoleService baseRoleService;

    @Override
    @Transactional
    public void add(ResponseModel<Boolean> responseModel, BaseDeptAddParam addParam) {
        if (NullUtil.isNull((Object)((BaseDeptMapper)this.baseMapper).findByData(addParam.getData()))) {
            ResponseUtil.executeSuccess(responseModel, (Object)this.save(SpringBeanUtil.copy((Object)addParam, BaseDept.class)));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u90e8\u95e8\u503c\u5df2\u5b58\u5728");
        }
    }

    @Override
    @Transactional
    public void edit(ResponseModel<Boolean> responseModel, BaseDeptEditParam editParam) {
        BaseDept baseDept = ((BaseDeptMapper)this.baseMapper).findByData(editParam.getData());
        if (NullUtil.isNull((Object)baseDept) || baseDept.getId().equals(editParam.getId())) {
            ResponseUtil.executeSuccess(responseModel, (Object)this.updateById(SpringBeanUtil.copy((Object)editParam, BaseDept.class)));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u90e8\u95e8\u503c\u5df2\u5b58\u5728");
        }
    }

    @Override
    @Transactional
    public void status(ResponseModel<Boolean> responseModel, BaseDeptStatusParam statusParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)(((BaseDeptMapper)this.baseMapper).updateStatusByIds(statusParam.getStatus(), statusParam.getId()) > 0 ? 1 : 0));
    }

    @Override
    public void findAll(ResponseModel<List<BaseDept>> responseModel, BaseDeptFindAllParam findAllParam) {
        List<BaseDept> oldBaseDeptList = ((BaseDeptMapper)this.baseMapper).findAllByNameAndStatus(findAllParam);
        if (EmptyUtil.isNotNull(oldBaseDeptList) && (EmptyUtil.isNotNull((String)findAllParam.getName()) || NullUtil.isNotNull((Object)findAllParam.getStatus()) && !findAllParam.getStatus().booleanValue())) {
            List<String> pidList = oldBaseDeptList.stream().map(BaseDept::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList());
            while (pidList.size() > 0) {
                oldBaseDeptList.addAll(this.findAll(pidList));
            }
            List newBaseDeptList = ListUtil.distinct(oldBaseDeptList, (source, target) -> source.getId().equals(target.getId()));
            newBaseDeptList.sort((sourceBaseDept, targetBaseDept) -> targetBaseDept.getCreateTime().compareTo(sourceBaseDept.getCreateTime()));
            ResponseUtil.executeSuccess(responseModel, (Object)newBaseDeptList);
        } else {
            ResponseUtil.executeSuccess(responseModel, oldBaseDeptList);
        }
    }

    private List<BaseDept> findAll(List<String> pidList) {
        ArrayList<BaseDept> baseDeptList = new ArrayList<BaseDept>();
        while (pidList.size() > 0) {
            baseDeptList.addAll(this.listByIds(ListUtil.extract(pidList, (int)1000)));
        }
        pidList.addAll(baseDeptList.stream().map(BaseDept::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList()));
        return baseDeptList;
    }

    @Override
    public void findAllByUserId(ResponseModel<List<BaseDept>> responseModel, String userId) {
        ResponseUtil.executeSuccess(responseModel, ((BaseDeptMapper)this.baseMapper).findAllByUserId(userId));
    }

    @Override
    public void findAllByRole(ResponseModel<List<BaseDept>> responseModel, BaseDeptFindAllByRoleParam findAllByRoleParam, String token) {
        if (EmptyUtil.isNull((String)findAllByRoleParam.getUserId())) {
            findAllByRoleParam.setUserId(this.configRedisValueExt.getToken(token));
        }
        if (this.baseRoleService.findAllDataByUserId(findAllByRoleParam.getUserId()).contains("admin")) {
            this.findAll(responseModel, findAllByRoleParam);
        } else {
            this.findAllByUserId(responseModel, findAllByRoleParam.getUserId());
        }
    }
}

