/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.mapper.BaseMenuMapper;
import org.wxz.business.mapper.BaseRoleMenuRelaMapper;
import org.wxz.business.model.BaseMenu;
import org.wxz.business.model.BaseRoleMenuRela;
import org.wxz.business.param.BaseMenuFindAllParam;
import org.wxz.business.param.BaseMenuStatusParam;
import org.wxz.business.response.BaseMenuFindByIdResponse;
import org.wxz.business.service.BaseMenuService;
import org.wxz.tools.apache.spring.bean.SpringBeanUtil;
import org.wxz.tools.oracle.collection.util.ListUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.type.util.StringUtil;
import org.wxz.tools.oracle.uuid.util.UUIDUtil;

@Service
public class BaseMenuServiceImpl
extends ServiceImpl<BaseMenuMapper, BaseMenu>
implements BaseMenuService {
    private static final Logger log = LoggerFactory.getLogger(BaseMenuServiceImpl.class);
    @Resource
    private BaseRoleMenuRelaMapper baseRoleMenuRelaMapper;
    @Resource
    private ConfigRedisValueExt<String, String> configRedisValueExt;

    @Override
    public void auth(ResponseModel<List<BaseMenu>> responseModel, String token) {
        ResponseUtil.executeSuccess(responseModel, ((BaseMenuMapper)this.baseMapper).findAllByUserIdAndDescByIndex(this.configRedisValueExt.getToken(token)));
    }

    @Override
    public void findAll(ResponseModel<List<BaseMenu>> responseModel, BaseMenuFindAllParam findAllParam) {
        List<BaseMenu> oldBaseMenuList = ((BaseMenuMapper)this.baseMapper).findAllByNameAndStatus(findAllParam);
        if (EmptyUtil.isNotNull(oldBaseMenuList) && (EmptyUtil.isNotNull((String)findAllParam.getName()) || NullUtil.isNotNull((Object)findAllParam.getStatus()) && !findAllParam.getStatus().booleanValue())) {
            List<String> pidList = oldBaseMenuList.stream().map(BaseMenu::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList());
            while (pidList.size() > 0) {
                oldBaseMenuList.addAll(this.findAll(pidList));
            }
            List newBaseMenuList = ListUtil.distinct(oldBaseMenuList, (source, target) -> source.getId().equals(target.getId()));
            newBaseMenuList.sort((sourceBaseMenu, targetBaseMenu) -> targetBaseMenu.getCreateTime().compareTo(sourceBaseMenu.getCreateTime()));
            ResponseUtil.executeSuccess(responseModel, (Object)newBaseMenuList);
        } else {
            ResponseUtil.executeSuccess(responseModel, oldBaseMenuList);
        }
    }

    private List<BaseMenu> findAll(List<String> pidList) {
        ArrayList<BaseMenu> baseMenuList = new ArrayList<BaseMenu>();
        while (pidList.size() > 0) {
            baseMenuList.addAll(this.listByIds(ListUtil.extract(pidList, (int)1000)));
        }
        pidList.addAll(baseMenuList.stream().map(BaseMenu::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList()));
        return baseMenuList;
    }

    @Override
    @Transactional
    public void add(ResponseModel<Boolean> responseModel, BaseMenu baseMenu, List<String> roleId) {
        baseMenu.setId(UUIDUtil.uuidNoLineAndToLower());
        this.role(baseMenu, roleId);
        ResponseUtil.executeSuccess(responseModel, (Object)this.save(baseMenu));
    }

    @Override
    public void findById(ResponseModel<BaseMenuFindByIdResponse> responseModel, String id) {
        BaseMenuFindByIdResponse baseMenuFindByIdResponse = (BaseMenuFindByIdResponse)SpringBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), BaseMenuFindByIdResponse.class);
        baseMenuFindByIdResponse.setRoleId(this.baseRoleMenuRelaMapper.findAllByMenuId(id));
        ResponseUtil.executeSuccess(responseModel, (Object)baseMenuFindByIdResponse);
    }

    @Override
    @Transactional
    public void edit(ResponseModel<Boolean> responseModel, final BaseMenu baseMenu, List<String> roleId) {
        this.baseRoleMenuRelaMapper.deleteByMenuIds((List<String>)new ArrayList<String>(){
            {
                this.add(baseMenu.getId());
            }
        });
        this.role(baseMenu, roleId);
        ResponseUtil.executeSuccess(responseModel, (Object)this.updateById(baseMenu));
    }

    private void role(BaseMenu baseMenu, List<String> roleId) {
        roleId.forEach(oneRoleId -> this.baseRoleMenuRelaMapper.insert(new BaseRoleMenuRela(baseMenu.getId(), (String)oneRoleId)));
    }

    @Override
    @Transactional
    public void status(ResponseModel<Boolean> responseModel, BaseMenuStatusParam statusParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)(((BaseMenuMapper)this.baseMapper).updateStatusByIds(statusParam.getStatus(), statusParam.getId()) > 0 ? 1 : 0));
    }
}

