/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wxz.base.page.PageResponse;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.dto.query.BaseUserRelaDept;
import org.wxz.business.mapper.BaseDeptMapper;
import org.wxz.business.mapper.BaseRoleMapper;
import org.wxz.business.mapper.BaseUserDeptRelaMapper;
import org.wxz.business.mapper.BaseUserMapper;
import org.wxz.business.mapper.BaseUserRoleRelaMapper;
import org.wxz.business.model.BaseDept;
import org.wxz.business.model.BaseUser;
import org.wxz.business.model.BaseUserDeptRela;
import org.wxz.business.model.BaseUserRoleRela;
import org.wxz.business.param.BaseUserAddParam;
import org.wxz.business.param.BaseUserEditForAdminParam;
import org.wxz.business.param.BaseUserModifyPasswordParam;
import org.wxz.business.param.BaseUserPageParam;
import org.wxz.business.param.BaseUserResetPasswordParam;
import org.wxz.business.param.BaseUserStatusParam;
import org.wxz.business.response.BaseUserFindByIdContainsDeptResponse;
import org.wxz.business.response.BaseUserFindByIdContainsRolesAndDeptResponse;
import org.wxz.business.response.BaseUserPageResponse;
import org.wxz.business.service.BaseUserService;
import org.wxz.business.util.page.PageUtil;
import org.wxz.tools.apache.spring.bean.SpringBeanUtil;
import org.wxz.tools.oracle.codec.util.MD5Util;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.type.util.StringUtil;
import org.wxz.tools.oracle.uuid.util.UUIDUtil;

@Service
@RefreshScope
public class BaseUserServiceImpl
extends ServiceImpl<BaseUserMapper, BaseUser>
implements BaseUserService {
    private static final Logger log = LoggerFactory.getLogger(BaseUserServiceImpl.class);
    @Value(value="${system.default.login.password:123456}")
    private String password;
    @Resource
    private BaseRoleMapper baseRoleMapper;
    @Resource
    private BaseUserDeptRelaMapper baseUserDeptRelaMapper;
    @Resource
    private BaseUserRoleRelaMapper baseUserRoleRelaMapper;
    @Resource
    private BaseDeptMapper baseDeptMapper;

    @Override
    public void page(ResponseModel<PageResponse<BaseUserPageResponse>> responseModel, Page<BaseUserRelaDept> page, BaseUserPageParam pageParam, String userId) {
        page.setCurrent(pageParam.getCurrent().longValue());
        page.setSize(pageParam.getSize().longValue());
        ((BaseUserMapper)this.baseMapper).page(page, pageParam, userId);
        PageResponse pageResponse = PageUtil.page(page, BaseUserPageResponse.class);
        if (EmptyUtil.isNotNull((List)pageResponse.getRecords())) {
            for (BaseUserPageResponse baseUserPageResponse : pageResponse.getRecords()) {
                baseUserPageResponse.setRole(this.baseRoleMapper.findAllByUserId(baseUserPageResponse.getId()));
            }
        }
        ResponseUtil.executeSuccess(responseModel, (Object)pageResponse);
    }

    @Override
    @Transactional
    public void add(ResponseModel<Boolean> responseModel, BaseUserAddParam addParam) {
        BaseUser baseUser = (BaseUser)SpringBeanUtil.copy((Object)addParam, BaseUser.class);
        if (NullUtil.isNull((Object)((BaseUserMapper)this.baseMapper).findByUsername(baseUser.getUsername()))) {
            baseUser.setId(UUIDUtil.uuidNoLineAndToLower());
            baseUser.setPassword(MD5Util.encrypt((String)baseUser.getPassword()));
            this.dept(baseUser, addParam.getOtherDeptId());
            this.role(baseUser, addParam.getRoleId());
            ResponseUtil.executeSuccess(responseModel, (Object)this.save(baseUser));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void findByIdContainsRolesAndDept(ResponseModel<BaseUserFindByIdContainsRolesAndDeptResponse> responseModel, String id) {
        BaseUserFindByIdContainsRolesAndDeptResponse baseUserFindByIdContainsRolesAndDeptResponse = (BaseUserFindByIdContainsRolesAndDeptResponse)SpringBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), BaseUserFindByIdContainsRolesAndDeptResponse.class);
        baseUserFindByIdContainsRolesAndDeptResponse.setRole(this.baseRoleMapper.findAllByUserId(id));
        baseUserFindByIdContainsRolesAndDeptResponse.setDept((BaseDept)this.baseDeptMapper.selectById((Serializable)((Object)baseUserFindByIdContainsRolesAndDeptResponse.getDeptId())));
        baseUserFindByIdContainsRolesAndDeptResponse.setOtherDept(this.baseDeptMapper.findAllByUserId(id));
        ResponseUtil.executeSuccess(responseModel, (Object)baseUserFindByIdContainsRolesAndDeptResponse);
    }

    @Override
    public void findByIdContainsDept(ResponseModel<BaseUserFindByIdContainsDeptResponse> responseModel, String id) {
        BaseUserFindByIdContainsDeptResponse baseUserFindByIdContainsDeptResponse = (BaseUserFindByIdContainsDeptResponse)SpringBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), BaseUserFindByIdContainsDeptResponse.class);
        baseUserFindByIdContainsDeptResponse.setDept((BaseDept)this.baseDeptMapper.selectById((Serializable)((Object)baseUserFindByIdContainsDeptResponse.getDeptId())));
        baseUserFindByIdContainsDeptResponse.setOtherDept(this.baseDeptMapper.findAllByUserId(id));
        ResponseUtil.executeSuccess(responseModel, (Object)baseUserFindByIdContainsDeptResponse);
    }

    @Override
    @Transactional
    public void edit(ResponseModel<Boolean> responseModel, BaseUserEditForAdminParam editForAdminParam) {
        final BaseUser baseUser = (BaseUser)SpringBeanUtil.copy((Object)editForAdminParam, BaseUser.class);
        BaseUser tempBaseUser = ((BaseUserMapper)this.baseMapper).findByUsername(baseUser.getUsername());
        if (NullUtil.isNull((Object)tempBaseUser) || baseUser.getId().equals(tempBaseUser.getId())) {
            ArrayList<String> userIdList = new ArrayList<String>(){
                {
                    this.add(baseUser.getId());
                }
            };
            this.baseUserDeptRelaMapper.deleteByUserIds((List<String>)userIdList);
            this.baseUserRoleRelaMapper.deleteByUserIds((List<String>)userIdList);
            this.dept(baseUser, editForAdminParam.getOtherDeptId());
            this.role(baseUser, editForAdminParam.getRoleId());
            ResponseUtil.executeSuccess(responseModel, (Object)this.updateById(baseUser));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u8d26\u53f7\u5df2\u5b58\u5728");
        }
    }

    private void dept(BaseUser baseUser, List<String> deptId) {
        deptId.forEach(oneDeptId -> this.baseUserDeptRelaMapper.insert(new BaseUserDeptRela(baseUser.getId(), (String)oneDeptId)));
    }

    private void role(BaseUser baseUser, List<String> roleId) {
        roleId.forEach(oneRoleId -> this.baseUserRoleRelaMapper.insert(new BaseUserRoleRela(baseUser.getId(), (String)oneRoleId)));
    }

    @Override
    @Transactional
    public void status(ResponseModel<Boolean> responseModel, BaseUserStatusParam statusParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)(((BaseUserMapper)this.baseMapper).updateStatusByIds(statusParam.getStatus(), statusParam.getId()) > 0 ? 1 : 0));
    }

    @Override
    public void findAll(ResponseModel<List<BaseUser>> responseModel, boolean status) {
        ResponseUtil.executeSuccess(responseModel, ((BaseUserMapper)this.baseMapper).findAllByStatus(status));
    }

    @Override
    @Transactional
    public void modifyPassword(ResponseModel<Boolean> responseModel, BaseUserModifyPasswordParam modifyPasswordParam) {
        if (modifyPasswordParam.getOldPassword().equals(modifyPasswordParam.getNewPassword())) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u65b0\u8001\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
            return;
        }
        BaseUser baseUser = (BaseUser)this.getById((Serializable)((Object)modifyPasswordParam.getId()));
        if (StringUtil.notEquals((String)MD5Util.encrypt((String)modifyPasswordParam.getOldPassword()), (String)baseUser.getPassword())) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8001\u5bc6\u7801\u9519\u8bef");
            return;
        }
        ResponseUtil.executeSuccess(responseModel, (Object)this.setPassword(modifyPasswordParam.getId(), modifyPasswordParam.getNewPassword()));
    }

    @Override
    @Transactional
    public void resetPassword(ResponseModel<Boolean> responseModel, BaseUserResetPasswordParam resetPasswordParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.setPassword(resetPasswordParam.getId(), EmptyUtil.isNotNull((String)resetPasswordParam.getPassword()) ? resetPasswordParam.getPassword() : this.password));
    }

    private boolean setPassword(String id, String password) {
        BaseUser baseUser = new BaseUser();
        baseUser.setId(id);
        baseUser.setPassword(MD5Util.encrypt((String)password));
        return this.updateById(baseUser);
    }
}

