/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.model.BaseDept;
import org.wxz.business.param.BaseDeptAddParam;
import org.wxz.business.param.BaseDeptEditParam;
import org.wxz.business.param.BaseDeptFindAllByRoleParam;
import org.wxz.business.param.BaseDeptFindAllChildrenByRoleParam;
import org.wxz.business.param.BaseDeptFindAllChildrenParam;
import org.wxz.business.param.BaseDeptFindAllParam;
import org.wxz.business.param.BaseDeptFindAllParentByRoleParam;
import org.wxz.business.param.BaseDeptFindAllParentParam;
import org.wxz.business.param.BaseDeptStatusParam;
import org.wxz.business.service.BaseDeptService;
import org.wxz.tools.oracle.empty.util.EmptyUtil;

@Api(value="BaseDeptController", tags={"\u57fa\u7840\uff1a\u90e8\u95e8\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"base/dept"})
public class BaseDeptController {
    @Resource
    private BaseDeptService baseDeptService;
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"add"})
    public ResponseModel<Boolean> add(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDeptAddParam addParam) {
        this.baseDeptService.add(responseModel, addParam);
        return responseModel;
    }

    @ApiOperation(value="\u67e5\u627e")
    @GetMapping(value={"findById/{id}"})
    public ResponseModel<BaseDept> findById(ResponseModel<BaseDept> responseModel, @PathVariable String id) {
        ResponseUtil.executeSuccess(responseModel, (Object)this.baseDeptService.getById((Serializable)((Object)id)));
        return responseModel;
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"edit"})
    public ResponseModel<Boolean> edit(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDeptEditParam editParam) {
        this.baseDeptService.edit(responseModel, editParam);
        return responseModel;
    }

    @ApiOperation(value="\u72b6\u6001")
    @PostMapping(value={"status"})
    public ResponseModel<Boolean> status(ResponseModel<Boolean> responseModel, @Valid @RequestBody BaseDeptStatusParam statusParam) {
        this.baseDeptService.status(responseModel, statusParam);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff08\u5df2\u653e\u5f00\u9274\u6743\uff09")
    @PostMapping(value={"findAll"})
    public ResponseModel<List<BaseDept>> findAll(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllParam findAllParam) {
        this.baseDeptService.findAll(responseModel, findAllParam);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u7236\u4ee3")
    @PostMapping(value={"findAllParent"})
    public ResponseModel<List<BaseDept>> findAllParent(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllParentParam findAllParentParam) {
        this.baseDeptService.findAllParent(responseModel, findAllParentParam);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u5b50\u4ee3")
    @PostMapping(value={"findAllChildren"})
    public ResponseModel<List<BaseDept>> findAllChildren(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllChildrenParam findAllChildrenParam) {
        this.baseDeptService.findAllChildren(responseModel, findAllChildrenParam);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u6839\u636e\u7528\u6237")
    @GetMapping(value={"findAllByUserId", "findAllByUserId/{userId}"})
    public ResponseModel<List<BaseDept>> findAllByUserId(ResponseModel<List<BaseDept>> responseModel, @PathVariable(required=false) String userId, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllByUserId(responseModel, EmptyUtil.isNotNull((String)userId) ? userId : this.configRedisValueExt.getToken(token));
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u7236\u4ee3\uff1a\u6839\u636e\u7528\u6237")
    @GetMapping(value={"findAllParentByUserId", "findAllParentByUserId/{userId}"})
    public ResponseModel<List<BaseDept>> findAllParentByUserId(ResponseModel<List<BaseDept>> responseModel, @PathVariable(required=false) String userId, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllParentByUserId(responseModel, EmptyUtil.isNotNull((String)userId) ? userId : this.configRedisValueExt.getToken(token));
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u5b50\u4ee3\uff1a\u6839\u636e\u7528\u6237")
    @GetMapping(value={"findAllChildrenByUserIdAndPId/{pId}", "findAllChildrenByUserIdAndPId/{pId}/{userId}"})
    public ResponseModel<List<BaseDept>> findAllChildrenByUserIdAndPId(ResponseModel<List<BaseDept>> responseModel, @PathVariable(required=false) String userId, @PathVariable String pId, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllChildrenByUserIdAndPId(responseModel, EmptyUtil.isNotNull((String)userId) ? userId : this.configRedisValueExt.getToken(token), pId);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u6839\u636e\u89d2\u8272")
    @PostMapping(value={"findAllByRole"})
    public ResponseModel<List<BaseDept>> findAllByRole(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllByRoleParam findAllByRoleParam, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllByRole(responseModel, findAllByRoleParam, token);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u7236\u4ee3\uff1a\u6839\u636e\u89d2\u8272")
    @PostMapping(value={"findAllParentByRole"})
    public ResponseModel<List<BaseDept>> findAllParentByRole(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllParentByRoleParam findAllParentByRoleParam, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllParentByRole(responseModel, findAllParentByRoleParam, token);
        return responseModel;
    }

    @ApiOperation(value="\u5217\u8868\uff1a\u5b50\u4ee3\uff1a\u6839\u636e\u89d2\u8272")
    @PostMapping(value={"findAllChildrenByRole"})
    public ResponseModel<List<BaseDept>> findAllChildrenByRole(ResponseModel<List<BaseDept>> responseModel, @Valid @RequestBody BaseDeptFindAllChildrenByRoleParam findAllChildrenByRoleParam, @RequestHeader(value="token") String token) {
        this.baseDeptService.findAllChildrenByRole(responseModel, findAllChildrenByRoleParam, token);
        return responseModel;
    }
}

