/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.mapper.BaseDeptMapper;
import org.wxz.business.mapper.BaseMenuMapper;
import org.wxz.business.mapper.BaseRoleMapper;
import org.wxz.business.mapper.BaseUserMapper;
import org.wxz.business.model.BaseDept;
import org.wxz.business.model.BaseUser;
import org.wxz.business.param.LoginParam;
import org.wxz.business.response.LoginResponse;
import org.wxz.business.service.LoginService;
import org.wxz.tools.oracle.codec.util.MD5Util;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.type.util.StringUtil;

@Service
public class LoginServiceImpl
extends ServiceImpl<BaseUserMapper, BaseUser>
implements LoginService {
    @Resource(name="configRedisValueExt")
    private ConfigRedisValueExt<String, String, String> tokenConfigRedisValueExt;
    @Resource(name="configRedisValueExt")
    private ConfigRedisValueExt<String, String, String> imageCodeConfigRedisValueExt;
    @Resource
    private BaseDeptMapper baseDeptMapper;
    @Resource
    private BaseRoleMapper baseRoleMapper;
    @Resource
    private BaseMenuMapper baseMenuMapper;

    @Override
    public void login(ResponseModel<LoginResponse> responseModel, LoginParam loginParam) {
        if (StringUtil.notEqualsIgnoreCase((String)loginParam.getImageCode(), (String)this.imageCodeConfigRedisValueExt.getImageCode(loginParam.getImgId()))) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u56fe\u7247\u9a8c\u8bc1\u7801\u9519\u8bef");
            return;
        }
        BaseUser baseUser = ((BaseUserMapper)this.baseMapper).findByUsername(loginParam.getUsername());
        if (NullUtil.isNull((Object)baseUser)) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u8d26\u53f7\u4e0d\u5b58\u5728");
            return;
        }
        if (StringUtil.notEquals((String)baseUser.getPassword(), (String)MD5Util.encrypt((String)loginParam.getPassword()))) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u5bc6\u7801\u9519\u8bef");
            return;
        }
        if (!baseUser.getStatus().booleanValue()) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u7528\u6237\u5df2\u7981\u7528");
            return;
        }
        LoginResponse loginResponse = new LoginResponse();
        this.tokenConfigRedisValueExt.setToken(loginResponse.getToken(), baseUser.getId());
        loginResponse.setUser(baseUser);
        loginResponse.setDept((BaseDept)this.baseDeptMapper.selectById((Serializable)((Object)baseUser.getDeptId())));
        loginResponse.setRoles(this.baseRoleMapper.findAllByUserId(baseUser.getId()));
        loginResponse.setMenus(this.baseMenuMapper.findAllByUserIdAndDescByIndex(baseUser.getId()));
        ResponseUtil.executeSuccess(responseModel, (Object)loginResponse);
    }
}

