/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.wxz.tools.oracle.date.util.DateParseUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;

@ApiModel(value="BaseUserAddForAdminParam", description="\u57fa\u7840\uff1a\u7528\u6237\u6dfb\u52a0\uff1a\u7ba1\u7406\u5458\u53c2\u6570")
public class BaseUserAddForAdminParam
implements Serializable {
    @ApiModelProperty(value="\u771f\u540d", required=true)
    @NotBlank(message="\u771f\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u771f\u540d\u4e0d\u80fd\u4e3a\u7a7a") String realname;
    @ApiModelProperty(value="\u8d26\u53f7", required=true)
    @NotBlank(message="\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String username;
    @ApiModelProperty(value="\u5bc6\u7801", required=true)
    @NotBlank(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password;
    @ApiModelProperty(value="\u5934\u50cf")
    private String logo;
    @ApiModelProperty(value="\u90e8\u95e8\u4e3b\u952e", required=true)
    @NotBlank(message="\u90e8\u95e8\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u90e8\u95e8\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") String deptId;
    @ApiModelProperty(value="\u5176\u4ed6\u90e8\u95e8\u4e3b\u952e", required=true)
    @NotEmpty(message="\u5176\u4ed6\u90e8\u95e8\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="\u5176\u4ed6\u90e8\u95e8\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") List<String> otherDeptId;
    @ApiModelProperty(value="\u89d2\u8272\u4e3b\u952e", required=true)
    @NotEmpty(message="\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotEmpty(message="\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a") List<String> roleId;
    @ApiModelProperty(value="\u5907\u6ce8")
    private String desc;
    @ApiModelProperty(value="\u5269\u4f59\u5e74\u5047\u3001\u5929\u6570")
    private Integer annualLeaveDay;
    @ApiModelProperty(value="\u5269\u4f59\u5e74\u5047\u3001\u5c0f\u65f6")
    private Double annualLeaveHour;
    @ApiModelProperty(value="\u5165\u804c\u65f6\u95f4\uff08yyyy-MM-dd\uff09")
    private Date entryTime;
    @ApiModelProperty(value="\u8054\u7cfb\u5730\u5740")
    private String contactAddr;
    @ApiModelProperty(value="\u6027\u522b\uff1a0=\u5973\u30011=\u7537")
    private Boolean gender;
    @ApiModelProperty(value="\u624b\u673a\u53f7\u7801")
    private String phoneNumber;
    @ApiModelProperty(value="\u751f\u65e5\uff08yyyy-MM-dd\uff09")
    private Date birthday;
    @ApiModelProperty(value="\u8eab\u4efd\u8bc1\u53f7")
    private String idCard;

    public List<String> getOtherDeptId() {
        this.otherDeptId.add(this.deptId);
        return this.otherDeptId.stream().distinct().collect(Collectors.toList());
    }

    public Boolean getGender() {
        if (NullUtil.isNull((Object)this.gender) && EmptyUtil.isNotNull((String)this.idCard)) {
            return Integer.parseInt(this.idCard.substring(this.idCard.length() - 2, this.idCard.length() - 1)) % 2 != 0;
        }
        return this.gender;
    }

    public Date getBirthday() {
        if (NullUtil.isNull((Object)this.birthday) && EmptyUtil.isNotNull((String)this.idCard)) {
            return DateParseUtil.parse((String)this.idCard.substring(6, 14), (String)"yyyyMMdd");
        }
        return this.birthday;
    }

    public BaseUserAddForAdminParam() {
    }

    public BaseUserAddForAdminParam(String realname, String username, String password, String logo, String deptId, List<String> otherDeptId, List<String> roleId, String desc, Integer annualLeaveDay, Double annualLeaveHour, Date entryTime, String contactAddr, Boolean gender, String phoneNumber, Date birthday, String idCard) {
        this.realname = realname;
        this.username = username;
        this.password = password;
        this.logo = logo;
        this.deptId = deptId;
        this.otherDeptId = otherDeptId;
        this.roleId = roleId;
        this.desc = desc;
        this.annualLeaveDay = annualLeaveDay;
        this.annualLeaveHour = annualLeaveHour;
        this.entryTime = entryTime;
        this.contactAddr = contactAddr;
        this.gender = gender;
        this.phoneNumber = phoneNumber;
        this.birthday = birthday;
        this.idCard = idCard;
    }

    public String getRealname() {
        return this.realname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLogo() {
        return this.logo;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public List<String> getRoleId() {
        return this.roleId;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getAnnualLeaveDay() {
        return this.annualLeaveDay;
    }

    public Double getAnnualLeaveHour() {
        return this.annualLeaveHour;
    }

    public Date getEntryTime() {
        return this.entryTime;
    }

    public String getContactAddr() {
        return this.contactAddr;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setOtherDeptId(List<String> otherDeptId) {
        this.otherDeptId = otherDeptId;
    }

    public void setRoleId(List<String> roleId) {
        this.roleId = roleId;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setAnnualLeaveDay(Integer annualLeaveDay) {
        this.annualLeaveDay = annualLeaveDay;
    }

    public void setAnnualLeaveHour(Double annualLeaveHour) {
        this.annualLeaveHour = annualLeaveHour;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = contactAddr;
    }

    public void setGender(Boolean gender) {
        this.gender = gender;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
}

