/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.mapper.BaseDictMapper;
import org.wxz.business.model.BaseDict;
import org.wxz.business.param.BaseDictFindAllParam;
import org.wxz.business.param.BaseDictStatusParam;
import org.wxz.business.service.BaseDictService;
import org.wxz.tools.oracle.collection.util.ListUtil;
import org.wxz.tools.oracle.empty.util.EmptyUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;
import org.wxz.tools.oracle.type.util.StringUtil;

@Service
public class BaseDictServiceImpl
extends ServiceImpl<BaseDictMapper, BaseDict>
implements BaseDictService {
    @Override
    public void findAll(ResponseModel<List<BaseDict>> responseModel, BaseDictFindAllParam findAllParam) {
        List<BaseDict> oldBaseDictList = ((BaseDictMapper)this.baseMapper).findAllByNameAndNickAndStatus(findAllParam);
        if (EmptyUtil.isNotNull(oldBaseDictList) && (EmptyUtil.isNotNull((String)findAllParam.getName()) || EmptyUtil.isNotNull((String)findAllParam.getNick()) || NullUtil.isNotNull((Object)findAllParam.getStatus()) && !findAllParam.getStatus().booleanValue())) {
            List<String> pidList = oldBaseDictList.stream().map(BaseDict::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList());
            while (pidList.size() > 0) {
                oldBaseDictList.addAll(this.findAll(pidList));
            }
            List newBaseDictList = ListUtil.distinct(oldBaseDictList, (source, target) -> source.getId().equals(target.getId()));
            newBaseDictList.sort((sourceBaseDict, targetBaseDict) -> targetBaseDict.getCreateTime().compareTo(sourceBaseDict.getCreateTime()));
            ResponseUtil.executeSuccess(responseModel, (Object)newBaseDictList);
        } else {
            ResponseUtil.executeSuccess(responseModel, oldBaseDictList);
        }
    }

    private List<BaseDict> findAll(List<String> pidList) {
        ArrayList<BaseDict> baseDictList = new ArrayList<BaseDict>();
        while (pidList.size() > 0) {
            baseDictList.addAll(this.listByIds(ListUtil.extract(pidList, (int)1000)));
        }
        pidList.addAll(baseDictList.stream().map(BaseDict::getPId).filter(pId -> StringUtil.notEquals((String)"0", (String)pId)).distinct().collect(Collectors.toList()));
        return baseDictList;
    }

    @Override
    @Transactional
    public void add(ResponseModel<Boolean> responseModel, BaseDict baseDict) {
        if (EmptyUtil.isNotNull((String)baseDict.getName()) && NullUtil.isNotNull((Object)((BaseDictMapper)this.baseMapper).findByNameAndStatus(baseDict.getName(), null))) {
            ResponseUtil.invalidParameter(responseModel, (String)"\u5df2\u5b58\u5728\u8be5\u5b57\u5178\u540d");
        } else {
            ResponseUtil.executeSuccess(responseModel, (Object)this.save(baseDict));
        }
    }

    @Override
    @Transactional
    public void status(ResponseModel<Boolean> responseModel, BaseDictStatusParam statusParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)(((BaseDictMapper)this.baseMapper).updateStatusByIds(statusParam.getStatus(), statusParam.getId()) > 0 ? 1 : 0));
    }

    @Override
    public void findChildrenByName(ResponseModel<List<BaseDict>> responseModel, String name) {
        ResponseUtil.executeSuccess(responseModel, this.findChildrenByName(name));
    }

    @Override
    public void findChildrenByPid(ResponseModel<List<BaseDict>> responseModel, String pid) {
        ResponseUtil.executeSuccess(responseModel, this.findChildrenByPid(pid));
    }

    @Override
    public List<BaseDict> findChildrenByName(String name) {
        return ((BaseDictMapper)this.baseMapper).findChildrenByName(name);
    }

    @Override
    public List<BaseDict> findChildrenByPid(String pid) {
        return ((BaseDictMapper)this.baseMapper).findChildrenByPid(pid);
    }

    @Override
    public void findByNameAndStatus(ResponseModel<BaseDict> responseModel, String name, Boolean status) {
        ResponseUtil.executeSuccess(responseModel, (Object)((BaseDictMapper)this.baseMapper).findByNameAndStatus(name, status));
    }
}

