/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wxz.base.config.redis.value.ConfigRedisValueExt;
import org.wxz.base.page.PageParam;
import org.wxz.base.page.PageResponse;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.business.mapper.BaseRoleMapper;
import org.wxz.business.model.BaseRole;
import org.wxz.business.param.BaseRoleAddParam;
import org.wxz.business.param.BaseRoleEditParam;
import org.wxz.business.param.BaseRolePageParam;
import org.wxz.business.param.BaseRoleStatusParam;
import org.wxz.business.service.BaseRoleService;
import org.wxz.business.util.page.PageUtil;
import org.wxz.tools.apache.spring.bean.util.SpringBeanUtil;
import org.wxz.tools.oracle.empty.util.NullUtil;

@Service
public class BaseRoleServiceImpl
extends ServiceImpl<BaseRoleMapper, BaseRole>
implements BaseRoleService {
    @Resource
    private ConfigRedisValueExt<String, String, String> configRedisValueExt;

    @Override
    public void auth(ResponseModel<List<BaseRole>> responseModel, String token) {
        ResponseUtil.executeSuccess(responseModel, this.findAllByUserId(this.configRedisValueExt.getToken(token)));
    }

    @Override
    public void page(ResponseModel<PageResponse<BaseRole>> responseModel, Page<BaseRole> page, BaseRolePageParam pageParam) {
        PageUtil.page(page, (PageParam)pageParam);
        ResponseUtil.executeSuccess(responseModel, (Object)PageUtil.page(((BaseRoleMapper)this.baseMapper).page(page, pageParam)));
    }

    @Override
    @Transactional
    public void add(ResponseModel<Boolean> responseModel, BaseRoleAddParam addParam) {
        if (NullUtil.isNull((Object)((BaseRoleMapper)this.baseMapper).findByData(addParam.getData()))) {
            ResponseUtil.executeSuccess(responseModel, (Object)this.save(SpringBeanUtil.copy((Object)addParam, BaseRole.class)));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u89d2\u8272\u503c\u5df2\u5b58\u5728");
        }
    }

    @Override
    public void edit(ResponseModel<Boolean> responseModel, BaseRoleEditParam editParam) {
        BaseRole baseRole = ((BaseRoleMapper)this.baseMapper).findByData(editParam.getData());
        if (NullUtil.isNull((Object)baseRole) || baseRole.getId().equals(editParam.getId())) {
            ResponseUtil.executeSuccess(responseModel, (Object)this.updateById(SpringBeanUtil.copy((Object)editParam, BaseRole.class)));
        } else {
            ResponseUtil.invalidParameter(responseModel, (String)"\u8be5\u89d2\u8272\u503c\u5df2\u5b58\u5728");
        }
    }

    @Override
    @Transactional
    public void status(ResponseModel<Boolean> responseModel, BaseRoleStatusParam statusParam) {
        ResponseUtil.executeSuccess(responseModel, (Object)(((BaseRoleMapper)this.baseMapper).updateStatusByIds(statusParam.getStatus(), statusParam.getId()) > 0 ? 1 : 0));
    }

    @Override
    public void findAll(ResponseModel<List<BaseRole>> responseModel, boolean status) {
        ResponseUtil.executeSuccess(responseModel, ((BaseRoleMapper)this.baseMapper).findAllByStatus(status));
    }

    @Override
    public List<String> findAllDataByUserId(String userId) {
        return this.findAllDataByUserId(userId, true);
    }

    @Override
    public List<String> findAllDataByUserId(String userId, boolean extendsAdmin) {
        ArrayList<String> roleDataList = new ArrayList<String>();
        for (BaseRole baseRole : this.findAllByUserId(userId)) {
            roleDataList.add(baseRole.getData());
            if (!extendsAdmin || !baseRole.getExtendsAdmin().booleanValue() || roleDataList.contains("admin")) continue;
            roleDataList.add("admin");
        }
        return roleDataList;
    }

    @Override
    public List<BaseRole> findAllByUserId(String userId) {
        return ((BaseRoleMapper)this.baseMapper).findAllByUserId(userId);
    }
}

