package org.wxz.business.decorator;

import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import org.wxz.business.util.FluxUtil;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SystemServerHttpResponseDecorator extends ServerHttpResponseDecorator {
    
    private String enDecrypt;
    
    private DataBufferFactory dataBufferFactory;
    
    public SystemServerHttpResponseDecorator(ServerWebExchange exchange, String enDecrypt) {
        super(exchange.getResponse());
        this.enDecrypt = enDecrypt;
        dataBufferFactory = exchange.getResponse().bufferFactory();
    }
    
    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return MediaType.APPLICATION_JSON.equals(super.getHeaders().getContentType())
                &&
                body instanceof Flux
                ?
                super.writeWith(FluxUtil.getBody(true, super.getHeaders().getFirst(enDecrypt), Flux.from(body), dataBufferFactory))
                :
                super.writeWith(body);
    }
    
    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return super.writeAndFlushWith(body); // 这协议先不处理
    }
}