package org.wxz.business.advice.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.wxz.business.advice.SystemDefaultErrorWebExceptionHandler;

import java.util.stream.Collectors;

@Slf4j
@Configuration(proxyBeanMethods = false)
@AutoConfigureBefore({WebFluxAutoConfiguration.class})
@EnableConfigurationProperties({ServerProperties.class, ResourceProperties.class})
public class SystemErrorWebExceptionHandler {
    
    private ServerProperties serverProperties;
    
    public SystemErrorWebExceptionHandler(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }
    
    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    public ErrorWebExceptionHandler errorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ObjectProvider<ViewResolver> viewResolvers, ServerCodecConfigurer serverCodecConfigurer, ApplicationContext applicationContext) {
        SystemDefaultErrorWebExceptionHandler systemDefaultErrorWebExceptionHandler = new SystemDefaultErrorWebExceptionHandler(errorAttributes, resourceProperties, this.serverProperties.getError(), applicationContext);
        systemDefaultErrorWebExceptionHandler.setViewResolvers(viewResolvers.orderedStream().collect(Collectors.toList()));
        systemDefaultErrorWebExceptionHandler.setMessageReaders(serverCodecConfigurer.getReaders());
        systemDefaultErrorWebExceptionHandler.setMessageWriters(serverCodecConfigurer.getWriters());
        return systemDefaultErrorWebExceptionHandler;
    }
}