/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.advice;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.alibaba.fastjson.util.FastJsonUtil;

public class SystemDefaultErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SystemDefaultErrorWebExceptionHandler.class);

    public SystemDefaultErrorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        super.getError(request).printStackTrace();
        log.error(" <- Exception Message -> ", super.getError(request));
        ResponseModel responseModel = ResponseUtil.initResponseModel();
        ResponseUtil.causeException((ResponseModel)responseModel);
        return FastJsonUtil.toMap((Object)responseModel);
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> ((SystemDefaultErrorWebExceptionHandler)this).renderErrorResponse(arg_0));
    }

    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        return HttpStatus.OK.value();
    }
}

