/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.filter;

import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.wxz.base.config.header.ConfigHeader;
import org.wxz.base.util.i18n.I18nUtil;
import org.wxz.business.decorator.SystemServerHttpRequestDecorator;
import org.wxz.business.decorator.SystemServerHttpResponseDecorator;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
@RefreshScope
@Configuration
public class SystemGlobalFilter
implements GlobalFilter {
    private static final Logger log = LoggerFactory.getLogger(SystemGlobalFilter.class);
    @Value(value="${system.safety.en-decrypt.gateway:false}")
    private boolean enDecrypt;
    @Resource
    private ConfigHeader configHeader;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        I18nUtil.locale((String)exchange.getRequest().getHeaders().getFirst(this.configHeader.getI18n()));
        if (this.enDecrypt) {
            return chain.filter(exchange.mutate().request((ServerHttpRequest)new SystemServerHttpRequestDecorator(exchange, this.configHeader.getEnDecrypt())).response((ServerHttpResponse)new SystemServerHttpResponseDecorator(exchange, this.configHeader.getEnDecrypt())).build());
        }
        return chain.filter(exchange);
    }
}

