package org.wxz.business.decorator;

import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.wxz.business.util.FluxUtil;
import reactor.core.publisher.Flux;

public class SystemServerHttpRequestDecorator extends ServerHttpRequestDecorator {
    
    private String enDecrypt;
    
    public SystemServerHttpRequestDecorator(ServerWebExchange exchange, String enDecrypt) {
        super(exchange.getRequest());
        this.enDecrypt = enDecrypt;
    }
    
    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.putAll(super.getHeaders());
        httpHeaders.remove(HttpHeaders.CONTENT_LENGTH);
        httpHeaders.set(HttpHeaders.TRANSFER_ENCODING, "chunked");
        return httpHeaders;
    }
    
    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return super.getQueryParams(); // 这协议先不处理
    }
    
    @Override
    public Flux<DataBuffer> getBody() {
        return FluxUtil.getBody(false, this.getHeaders().getFirst(enDecrypt), super.getBody());
    }
}