/*
 * Decompiled with CFR 0.152.
 */
package org.wxz.business.advice.config;

import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.wxz.business.advice.SystemDefaultErrorWebExceptionHandler;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={WebFluxAutoConfiguration.class})
@EnableConfigurationProperties(value={ServerProperties.class, ResourceProperties.class})
public class SystemErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SystemErrorWebExceptionHandler.class);
    private ServerProperties serverProperties;

    public SystemErrorWebExceptionHandler(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Bean
    @Order(value=-2147483648)
    public ErrorWebExceptionHandler errorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ObjectProvider<ViewResolver> viewResolvers, ServerCodecConfigurer serverCodecConfigurer, ApplicationContext applicationContext) {
        SystemDefaultErrorWebExceptionHandler systemDefaultErrorWebExceptionHandler = new SystemDefaultErrorWebExceptionHandler(errorAttributes, resourceProperties, this.serverProperties.getError(), applicationContext);
        systemDefaultErrorWebExceptionHandler.setViewResolvers(viewResolvers.orderedStream().collect(Collectors.toList()));
        systemDefaultErrorWebExceptionHandler.setMessageReaders(serverCodecConfigurer.getReaders());
        systemDefaultErrorWebExceptionHandler.setMessageWriters(serverCodecConfigurer.getWriters());
        return systemDefaultErrorWebExceptionHandler;
    }
}

