package org.wxz.business.advice;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.*;
import org.wxz.base.response.model.ResponseModel;
import org.wxz.base.response.util.ResponseUtil;
import org.wxz.tools.alibaba.fastjson.util.FastJsonUtil;

import java.util.Map;

@Slf4j
public class SystemDefaultErrorWebExceptionHandler extends DefaultErrorWebExceptionHandler {
    
    public SystemDefaultErrorWebExceptionHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }
    
    @Override
    protected Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        super.getError(request).printStackTrace();
        log.error(" <- Exception Message -> ", super.getError(request));
        ResponseModel<Object> responseModel = ResponseUtil.initResponseModel();
        ResponseUtil.causeException(responseModel);
        return (Map<String, Object>) FastJsonUtil.toMap(responseModel);
    }
    
    @Override
    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        // return super.getRoutingFunction(errorAttributes);
        return RouterFunctions.route(RequestPredicates.all(), this::renderErrorResponse);
    }
    
    @Override
    protected int getHttpStatus(Map<String, Object> errorAttributes) {
        // return super.getHttpStatus(errorAttributes);
        return HttpStatus.OK.value();
    }
}