package org.wxz.business.filter;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.wxz.base.config.header.ConfigHeader;
import org.wxz.base.config.header.i18n.util.I18nUtil;
import org.wxz.business.decorator.SystemServerHttpRequestDecorator;
import org.wxz.business.decorator.SystemServerHttpResponseDecorator;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;

@Slf4j
@Order(Ordered.HIGHEST_PRECEDENCE)
@RefreshScope
@Configuration
public class SystemGlobalFilter implements GlobalFilter { // http://www.manongjc.com/detail/58-whqkpreyyvvgbaz.html
    
    @Value("${system.safety.en-decrypt.gateway:false}")
    private boolean enDecrypt;
    
    @Resource
    private ConfigHeader configHeader;
    
    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        
        I18nUtil.start(exchange.getRequest().getHeaders().getFirst(configHeader.getI18n()));
        
        if (enDecrypt) {
            return chain.filter(
                    exchange.mutate()
                            .request(new SystemServerHttpRequestDecorator(exchange, configHeader.getEnDecrypt()))
                            .response(new SystemServerHttpResponseDecorator(exchange, configHeader.getEnDecrypt()))
                            .build()
            );
        } else {
            return chain.filter(exchange);
        }
    }
}