package org.wxz.business.util;

import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.wxz.base.config.endecrypt.util.EnDecryptUtil;
import reactor.core.publisher.Flux;

public abstract class FluxUtil {
    
    public static Flux<DataBuffer> getBody(boolean enDecrypt, String algorithmX, Flux<DataBuffer> flux) {
        return getBody(enDecrypt, algorithmX, flux, new DefaultDataBufferFactory());
    }
    
    public static Flux<DataBuffer> getBody(boolean enDecrypt, String algorithmX, Flux<DataBuffer> flux, DataBufferFactory dataBufferFactory) {
        return flux
                .buffer()
                .map(
                        dataBuffers -> {
                            DataBuffer dataBuffer = dataBufferFactory.join(dataBuffers);
                            byte[] bytes = new byte[dataBuffer.readableByteCount()];
                            dataBuffer.read(bytes);
                            DataBufferUtils.release(dataBuffer);
                            return dataBufferFactory.wrap(enDecrypt ? EnDecryptUtil.encrypt(algorithmX, bytes) : EnDecryptUtil.decrypt(algorithmX, bytes));
                        }
                );
    }
}