/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.config;

import org.mx.dal.config.DalRdbConfig;
import org.mx.dal.config.JpaConfigBean;
import org.mx.dal.service.EntityManagerService;
import org.mx.dal.service.GeneralAccessor;
import org.mx.dal.service.GeneralDictAccessor;
import org.mx.dal.service.JdbcBatchAccessor;
import org.mx.dal.service.impl.GeneralAccessorImpl;
import org.mx.dal.service.impl.GeneralDictAccessorImpl;
import org.mx.dal.service.impl.JdbcBatchAccessorImpl;
import org.mx.dbcp.MyDbcp2DataSourceFactoryUtil;
import org.mx.spring.session.SessionDataStore;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Import(value={DalRdbConfig.class})
@EnableTransactionManagement
public class DalHibernateConfig {
    @Bean(name={"jdbcBatchAccessor"})
    public JdbcBatchAccessor jdbcBatchAccessor(JdbcTemplate jdbcTemplate) {
        return new JdbcBatchAccessorImpl(jdbcTemplate);
    }

    public static LocalContainerEntityManagerFactoryBean createEntityManagerFactoryBean(Environment env, MyDbcp2DataSourceFactoryUtil util, String dbname, String jpaname) {
        HibernateJpaVendorAdapter adapter = new HibernateJpaVendorAdapter();
        JpaConfigBean jpaConfigBean = new JpaConfigBean(env, jpaname);
        adapter.setDatabase(Database.valueOf((String)jpaConfigBean.getJpaDatabase()));
        adapter.setDatabasePlatform(jpaConfigBean.getJpaDatabasePlatform());
        adapter.setGenerateDdl(jpaConfigBean.isGenerateDDL());
        adapter.setShowSql(jpaConfigBean.isShowSQL());
        adapter.setPrepareConnection(true);
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(util.getDataSource(dbname));
        emf.setPersistenceUnitName(jpaConfigBean.getUnitName());
        emf.setPackagesToScan(jpaConfigBean.getJpaEntityPackages());
        emf.setJpaVendorAdapter((JpaVendorAdapter)adapter);
        return emf;
    }

    @Bean(value={"entityManagerFactory"})
    @Primary
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryBean(Environment env, MyDbcp2DataSourceFactoryUtil util) {
        return DalHibernateConfig.createEntityManagerFactoryBean(env, util, "db", "jpa");
    }

    @Bean(value={"transactionManager"})
    @Primary
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory") LocalContainerEntityManagerFactoryBean containerEntityManagerFactoryBean) {
        return new JpaTransactionManager(containerEntityManagerFactoryBean.getObject());
    }

    @Bean(name={"generalAccessorJpa"})
    public GeneralAccessor generalAccessorJpa(@Qualifier(value="entityManagerService") EntityManagerService entityManagerService, SessionDataStore sessionDataStore) {
        return new GeneralAccessorImpl(entityManagerService, sessionDataStore);
    }

    @Bean(name={"generalDictAccessorJpa"})
    public GeneralDictAccessor generalDictAccessorJpa(@Qualifier(value="entityManagerService") EntityManagerService entityManagerService, SessionDataStore sessionDataStore) {
        return new GeneralDictAccessorImpl(entityManagerService, sessionDataStore);
    }

    @Bean(name={"generalAccessor"})
    public GeneralAccessor generalAccessor(ApplicationContext context) {
        return (GeneralAccessor)context.getBean("generalAccessorJpa", GeneralAccessor.class);
    }

    @Bean(name={"generalDictAccessor"})
    public GeneralDictAccessor generalDictAccessor(ApplicationContext context) {
        return (GeneralDictAccessor)context.getBean("generalDictAccessorJpa", GeneralDictAccessor.class);
    }
}

