/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.config;

import org.mx.StringUtils;
import org.springframework.core.env.Environment;

public class JpaConfigBean {
    private Environment env;
    private String prefix;

    public JpaConfigBean(Environment env, String prefix) {
        this.env = env;
        this.prefix = prefix;
    }

    public String getUnitName() {
        return this.env.getProperty(String.format("%s.unitName", this.prefix), "default");
    }

    public String getJpaDatabase() {
        return this.env.getProperty(String.format("%s.database", this.prefix), "H2");
    }

    public String getJpaDatabasePlatform() {
        return this.env.getProperty(String.format("%s.databasePlatform", this.prefix), "org.hibernate.dialect.H2Dialect");
    }

    public String[] getJpaEntityPackages() {
        return StringUtils.split((String)this.env.getProperty(String.format("%s.entity.packages", this.prefix), ""));
    }

    public boolean isGenerateDDL() {
        return (Boolean)this.env.getProperty(String.format("%s.generateDDL", this.prefix), Boolean.class, (Object)false);
    }

    public boolean isShowSQL() {
        return (Boolean)this.env.getProperty(String.format("%s.showSQL", this.prefix), Boolean.class, (Object)false);
    }
}

