/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.mx.dal.EntityFactory;
import org.mx.dal.Pagination;
import org.mx.dal.entity.Base;
import org.mx.dal.entity.PO;
import org.mx.dal.error.UserInterfaceDalErrorException;
import org.mx.dal.service.AbstractGeneralAccessor;
import org.mx.dal.service.EntityManagerService;
import org.mx.dal.service.GeneralAccessor;
import org.mx.error.UserInterfaceSystemErrorException;
import org.mx.spring.session.SessionDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class GeneralAccessorImpl
extends AbstractGeneralAccessor
implements GeneralAccessor {
    private static final Logger logger = LoggerFactory.getLogger(GeneralAccessorImpl.class);
    private EntityManager entityManager;

    public GeneralAccessorImpl(EntityManagerService ems, SessionDataStore sessionDataStore) {
        this.entityManager = ems.getEntityManager();
        this.sessionDataStore = sessionDataStore;
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(Class<T> clazz, boolean isValid) {
        return this.count((GeneralAccessor.ConditionGroup)this.createValidCondition(isValid), clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        if (clazz.isInterface()) {
            try {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
            }
        }
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root rootCount = countQuery.from(clazz);
        countQuery.select((Selection)cb.count((Expression)rootCount));
        if (group != null) {
            countQuery.where((Expression)this.createGroupPredicate(cb, rootCount, group));
        }
        return (Long)this.entityManager.createQuery(countQuery).getSingleResult();
    }

    public <T extends PO> List<T> list(Pagination pagination, Class<T> clazz, boolean isValid) {
        return this.find(pagination, (GeneralAccessor.ConditionGroup)this.createValidCondition(isValid), null, clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(Class<T> clazz) {
        return this.count(clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Class<T> clazz) {
        return this.list(clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Class<T> clazz, boolean isValid) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            if (isValid) {
                return this.find((GeneralAccessor.ConditionGroup)this.createValidCondition(true), clazz);
            }
            Query query = this.entityManager.createQuery(String.format("SELECT entity FROM %s entity", clazz.getName()));
            List result = query.getResultList();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("List %d entity[%s].", result.size(), clazz.getName()));
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Pagination pagination, Class<T> clazz) {
        return this.list(pagination, clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> T getById(String id, Class<T> clazz) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            return (T)((PO)this.entityManager.find(clazz, (Object)id));
        }
        catch (ClassNotFoundException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Entity interface[%s] not be implemented.", clazz.getName()), (Throwable)ex);
            }
            return null;
        }
    }

    private <T extends PO> Predicate createCondition(CriteriaBuilder cb, Root<T> root, GeneralAccessor.ConditionTuple tuple) {
        switch (tuple.operate) {
            case CONTAIN: 
            case FUZZY: {
                if (tuple.value instanceof Collection && ((Collection)tuple.value).size() > 1) {
                    int size = ((Collection)tuple.value).size();
                    Predicate[] predicates = new Predicate[size];
                    int index = 0;
                    for (Object v : (Collection)tuple.value) {
                        predicates[index] = cb.like(this.getField(tuple.field, root), String.format("%%%s%%", v));
                        ++index;
                    }
                    return cb.or(predicates);
                }
                Object v = tuple.value instanceof Collection ? ((Collection)tuple.value).iterator().next() : tuple.value;
                return cb.like(this.getField(tuple.field, root), String.format("%%%s%%", v));
            }
            case PREFIX: {
                return cb.like(this.getField(tuple.field, root), String.format("%s%%", tuple.value));
            }
            case EQ: {
                return cb.equal(this.getField(tuple.field, root), tuple.value);
            }
            case LT: {
                return cb.lt(this.getField(tuple.field, root), (Number)tuple.value);
            }
            case GT: {
                return cb.gt(this.getField(tuple.field, root), (Number)tuple.value);
            }
            case LTE: {
                return cb.le(this.getField(tuple.field, root), (Number)tuple.value);
            }
            case GTE: {
                return cb.ge(this.getField(tuple.field, root), (Number)tuple.value);
            }
            case IS_NULL: {
                return cb.isNull(this.getField(tuple.field, root));
            }
            case IS_NOT_NULL: {
                return cb.isNotNull(this.getField(tuple.field, root));
            }
            case IN: {
                if (tuple.value instanceof Collection && ((Collection)tuple.value).size() > 1) {
                    CriteriaBuilder.In in = cb.in(this.getField(tuple.field, root));
                    for (Object v : (Collection)tuple.value) {
                        in.value(v);
                    }
                    return in;
                }
                return cb.equal(this.getField(tuple.field, root), tuple.value);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error(String.format("Unsupported the operate type: %s.", tuple.operate));
        }
        throw new UserInterfaceSystemErrorException(UserInterfaceSystemErrorException.SystemErrors.SYSTEM_UNSUPPORTED_OPERATE);
    }

    private <T extends PO> Predicate createGroupPredicate(CriteriaBuilder cb, Root<T> root, GeneralAccessor.ConditionGroup group) {
        if (group.getItems().size() == 1) {
            return this.createCondition(cb, root, (GeneralAccessor.ConditionTuple)group.getItems().get(0));
        }
        Predicate[] predicates = new Predicate[group.getItems().size()];
        for (int index = 0; index < group.getItems().size(); ++index) {
            predicates[index] = this.createGroupPredicate(cb, root, (GeneralAccessor.ConditionGroup)group.getItems().get(index));
        }
        return group.getOperateType() == GeneralAccessor.ConditionGroup.OperateType.AND ? cb.and(predicates) : cb.or(predicates);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> find(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        return this.find(null, group, null, clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> find(Pagination pagination, GeneralAccessor.ConditionGroup group, GeneralAccessor.RecordOrderGroup orderGroup, Class<T> clazz) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            if (pagination != null) {
                CriteriaQuery countQuery = cb.createQuery(Long.class);
                Root rootCount = countQuery.from(clazz);
                countQuery.select((Selection)cb.count((Expression)rootCount));
                if (group != null) {
                    countQuery.where((Expression)this.createGroupPredicate(cb, rootCount, group));
                }
                pagination.setTotal(((Long)this.entityManager.createQuery(countQuery).getSingleResult()).intValue());
            }
            CriteriaQuery criteriaQuery = cb.createQuery(clazz);
            Root root = criteriaQuery.from(clazz);
            if (group != null) {
                criteriaQuery.where((Expression)this.createGroupPredicate(cb, root, group));
            }
            if (orderGroup != null && !orderGroup.getOrders().isEmpty()) {
                ArrayList orders = new ArrayList();
                orderGroup.getOrders().forEach(order -> {
                    if (order.getType() == GeneralAccessor.RecordOrder.OrderType.ASC) {
                        orders.add(cb.asc((Expression)root.get(order.getField())));
                    } else {
                        orders.add(cb.desc((Expression)root.get(order.getField())));
                    }
                });
                criteriaQuery.orderBy(orders);
            }
            TypedQuery query = this.entityManager.createQuery(criteriaQuery);
            if (pagination != null) {
                query.setFirstResult((pagination.getPage() - 1) * pagination.getSize());
                query.setMaxResults(pagination.getSize());
            }
            return query.getResultList();
        }
        catch (ClassNotFoundException ex) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    private <T extends PO> Path<?> getField(String field, Root<T> root) {
        String[] path = field.split("\\.");
        Path result = root;
        for (String p : path) {
            result = result.get(p);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public <T extends PO> T findOne(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        List<T> result = this.find(group, clazz);
        if (result != null && result.size() > 0) {
            return (T)((PO)result.get(0));
        }
        return null;
    }

    @Transactional
    public <T extends PO> T save(T t) {
        return this.save(t, true);
    }

    private <T extends PO> T save(T t, boolean needFlush) {
        boolean isNew = this.prepareSave((PO)t);
        if (isNew) {
            this.entityManager.persist(t);
        } else {
            this.entityManager.merge(t);
        }
        if (needFlush) {
            this.entityManager.flush();
            this.entityManager.clear();
            t = this.getById(t.getId(), t.getClass());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Save(%s) entity success, entity: %s.", isNew ? "INSERT" : "UPDATE", t));
        }
        return t;
    }

    @Transactional
    public <T extends PO> List<T> save(List<T> ts) {
        if (ts != null && !ts.isEmpty()) {
            ArrayList<Boolean> isNews = new ArrayList<Boolean>(ts.size());
            for (PO t : ts) {
                isNews.add(this.prepareSave(t));
            }
            for (int index = 0; index < ts.size(); ++index) {
                PO t;
                t = (PO)ts.get(index);
                boolean isNew = (Boolean)isNews.get(index);
                if (isNew) {
                    this.entityManager.persist((Object)t);
                    continue;
                }
                this.entityManager.merge((Object)t);
            }
        }
        this.entityManager.flush();
        this.entityManager.clear();
        return ts;
    }

    @Transactional
    public <T extends PO> void clear(Class<T> clazz) {
        if (clazz.isInterface()) {
            try {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
            }
        }
        this.remove(this.list(clazz), false);
        this.entityManager.clear();
    }

    @Transactional
    public <T extends PO> T remove(String id, Class<T> clazz) {
        return this.remove(id, clazz, true);
    }

    @Transactional
    public <T extends PO> T remove(String id, Class<T> clazz, boolean logicRemove) {
        T t = this.getById(id, clazz);
        if (t == null) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_NOT_FOUND);
        }
        return this.remove(t, logicRemove);
    }

    @Transactional
    public <T extends PO> T remove(T t) {
        return this.remove(t, true);
    }

    @Transactional
    public <T extends PO> T remove(T t, boolean logicRemove) {
        return this.remove(t, logicRemove, true);
    }

    @Transactional
    public <T extends PO> List<T> remove(List<T> ts, boolean logicRemove) {
        for (PO t : ts) {
            this.remove(t, logicRemove, false);
        }
        this.entityManager.flush();
        return ts;
    }

    private <T extends PO> T remove(T t, boolean logicRemove, boolean needFlush) {
        if (t == null) {
            return t;
        }
        if (!(t instanceof Base)) {
            if (logger.isErrorEnabled()) {
                logger.error("The entity not implement Base interface.");
            }
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INVALID_PO);
        }
        Base removeEntity = (Base)this.getById(t.getId(), t.getClass());
        if (removeEntity == null) {
            return t;
        }
        if (logicRemove) {
            removeEntity.setValid(0);
            t = this.save(removeEntity, needFlush);
            return t;
        }
        this.entityManager.remove((Object)removeEntity);
        if (needFlush) {
            this.entityManager.flush();
        }
        return t;
    }
}

