/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.service.impl;

import java.util.List;
import org.mx.dal.entity.BaseDict;
import org.mx.dal.error.UserInterfaceDalErrorException;
import org.mx.dal.service.EntityManagerService;
import org.mx.dal.service.GeneralAccessor;
import org.mx.dal.service.GeneralDictAccessor;
import org.mx.dal.service.impl.GeneralAccessorImpl;
import org.mx.spring.session.SessionDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class GeneralDictAccessorImpl
extends GeneralAccessorImpl
implements GeneralDictAccessor {
    private static final Logger logger = LoggerFactory.getLogger(GeneralDictAccessorImpl.class);

    public GeneralDictAccessorImpl(EntityManagerService ems, SessionDataStore sessionDataStore) {
        super(ems, sessionDataStore);
    }

    @Transactional(readOnly=true)
    public <T extends BaseDict> T getByCode(String code, Class<T> clazz) throws UserInterfaceDalErrorException {
        List<T> result = super.find((GeneralAccessor.ConditionGroup)GeneralAccessor.ConditionTuple.eq((String)"code", (Object)code), clazz);
        if (result != null && result.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Found %d dict entity, entity: %s, code: %s.", result.size(), clazz.getName(), code));
            }
            return (T)((BaseDict)result.get(0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("The dict entity not found, entity: %s, code: %s.", clazz.getName(), code));
        }
        return null;
    }
}

