/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.service.impl;

import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.Table;
import org.mx.StringUtils;
import org.mx.dal.service.impl.AbstractJdbcBatchAccessorImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ReflectionUtils;

public class JdbcBatchAccessorImpl
extends AbstractJdbcBatchAccessorImpl {
    @Autowired
    public JdbcBatchAccessorImpl(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    protected String getTableName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        String name = null;
        if (table != null) {
            name = table.name();
        }
        if (StringUtils.isBlank(name)) {
            return entityClass.getName();
        }
        return name;
    }

    protected String getColumnName(Class<?> entityClass, String fieldName) {
        Field field = ReflectionUtils.findField(entityClass, (String)fieldName);
        Column column = field.getAnnotation(Column.class);
        if (column != null && !StringUtils.isBlank((String)column.name())) {
            return column.name();
        }
        return fieldName;
    }
}

