package org.mx.dal.entity;

import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.index.TextIndexed;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 基于Mongodb实现的基础字典实体
 *
 * @author : john.peng date : 2017/10/8
 * @see MongoBaseEntity
 * @see BaseDict
 */
@ToString(callSuper = true)
public class MongoBaseDictEntity extends MongoBaseEntity implements BaseDict {
    /**
	 * 
	 */
	private static final long serialVersionUID = -2148492944659254375L;
	@Indexed(unique = true)
    private @Getter @Setter String code;
    @TextIndexed
    private @Getter @Setter String name, desc;
}
