package org.mx.dal.entity;

import org.springframework.data.mongodb.core.mapping.DBRef;

import lombok.ToString;

import java.util.HashSet;
import java.util.Set;

/**
 * 基于Mongodb实现的基础树状字典实体
 * 
 * @param <T> 泛型定义
 *
 * @author : john.peng date : 2017/10/8
 * @see MongoBaseDictEntity
 * @see BaseDictTree
 */
@ToString(callSuper = true, exclude = { "children" })
public class MongoBaseDictTreeEntity<T extends BaseDictTree<T>> extends MongoBaseDictEntity implements BaseDictTree<T> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 6923691734362733820L;
	@DBRef
	private T parent;
	@DBRef
	private Set<T> children = new HashSet<>();

	/**
	 * {@inheritDoc}
	 *
	 * @see BaseDictTree#getParentId()
	 */
	@Override
	public String getParentId() {
		return parent == null ? null : parent.getId();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see BaseDictTree#getParent()
	 */
	@Override
	public T getParent() {
		return parent;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see BaseDictTree#setParent(BaseDictTree)
	 */
	@Override
	public void setParent(T parent) {
		this.parent = parent;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see BaseDictTree#getChildren()
	 */
	@Override
	public Set<T> getChildren() {
		return children;
	}
}
