package org.mx.dal.entity;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 基于Mongodb实现的基础实体
 *
 * @author : john.peng date : 2017/10/8
 * @see Base
 */
@ToString
public class MongoBaseEntity implements Base {
    /**
	 * 
	 */
	private static final long serialVersionUID = -1547133361167345442L;
	@Id
    private @Getter @Setter String id;
    @Indexed
    private @Getter @Setter long createdTime, updatedTime;
    private @Getter @Setter String operator;
    @Indexed
    private int valid = 1;

    /**
     * {@inheritDoc}
     *
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MongoBaseEntity that = (MongoBaseEntity) o;
        if (id != null ? !id.equals(that.id) : that.id != null) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * {@inheritDoc}
     *
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        return result;
    }

    /**
     * {@inheritDoc}
     *
     * @see Base#isValid()
     */
    @Override
    public boolean isValid() {
        return valid == 1;
    }

    /**
     * {@inheritDoc}
     *
     * @see Base#getValid()
     */
    @Override
    public int getValid() {
        return valid;
    }

    /**
     * {@inheritDoc}
     *
     * @see Base#setValid(boolean)
     */
    @Override
    public void setValid(boolean valid) {
        this.valid = valid ? 1 : 0;
    }

    /**
     * {@inheritDoc}
     *
     * @see Base#setValid(int)
     */
    @Override
    public void setValid(int valid) {
        this.valid = valid;
    }
}
