/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.config;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.mx.dal.config.DalConfig;
import org.mx.dal.service.GeneralAccessor;
import org.mx.dal.service.GeneralDictAccessor;
import org.mx.dal.service.impl.GeneralAccessorMongoImpl;
import org.mx.dal.service.impl.GeneralDictAccessorMongoImpl;
import org.mx.spring.config.SpringConfig;
import org.mx.spring.session.SessionDataStore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;

@Import(value={DalConfig.class, SpringConfig.class})
@ComponentScan(value={"org.mx.dal.service.impl"})
public class DalMongodbConfig {
    @Bean
    public ConnectionString connectionString(Environment env) {
        return new ConnectionString(env.getProperty("mongo.connection"));
    }

    @Bean
    public MongoClient mongoClient(ConnectionString connectionString) {
        return MongoClients.create((ConnectionString)connectionString);
    }

    @Bean
    public MongoDbFactory mongoDbFactory(MongoClient mongoClient, ConnectionString connectionString) {
        return new SimpleMongoClientDbFactory(mongoClient, connectionString.getDatabase());
    }

    @Bean(name={"mongoTemplate"})
    public MongoTemplate mongoTemplate(MongoDbFactory mongoDbFactory) {
        return new MongoTemplate(mongoDbFactory);
    }

    @Bean(name={"generalAccessorMongodb"})
    public GeneralAccessor generalAccessorMongodb(MongoTemplate template, SessionDataStore sessionDataStore) {
        return new GeneralAccessorMongoImpl(template, sessionDataStore);
    }

    @Bean(name={"generalDictAccessorMongodb"})
    public GeneralDictAccessor generalDictAccessorMongodb(MongoTemplate template, SessionDataStore sessionDataStore) {
        return new GeneralDictAccessorMongoImpl(template, sessionDataStore);
    }
}

