/*
 * Decompiled with CFR 0.152.
 */
package org.mx.dal.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bson.Document;
import org.mx.StringUtils;
import org.mx.dal.EntityFactory;
import org.mx.dal.Pagination;
import org.mx.dal.entity.Base;
import org.mx.dal.entity.BaseDictTree;
import org.mx.dal.entity.PO;
import org.mx.dal.error.UserInterfaceDalErrorException;
import org.mx.dal.service.AbstractGeneralAccessor;
import org.mx.dal.service.GeneralAccessor;
import org.mx.dal.service.GeneralTextSearchAccessor;
import org.mx.error.UserInterfaceSystemErrorException;
import org.mx.spring.session.SessionDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.TextQuery;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Transactional;

public class GeneralAccessorMongoImpl
extends AbstractGeneralAccessor
implements GeneralAccessor,
GeneralTextSearchAccessor {
    private static final Logger logger = LoggerFactory.getLogger(GeneralAccessorMongoImpl.class);
    private static final String ID_FIELD = "_id";
    protected MongoTemplate template;

    public GeneralAccessorMongoImpl(MongoTemplate template, SessionDataStore sessionDataStore) {
        this.template = template;
        this.sessionDataStore = sessionDataStore;
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(Class<T> clazz, boolean isValid) {
        return this.count((GeneralAccessor.ConditionGroup)this.createValidCondition(isValid), clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        if (clazz.isInterface()) {
            try {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error(String.format("The class[%s] not found.", clazz.getName()));
                }
                throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_NOT_FOUND);
            }
        }
        Query query = new Query();
        if (group != null && !group.getItems().isEmpty()) {
            query.addCriteria((CriteriaDefinition)this.createGroupCriteria(group));
        }
        return this.template.count(query, clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> long count(Class<T> clazz) {
        return this.count(clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Class<T> clazz, boolean isValid) {
        try {
            List<T> result;
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            if (isValid) {
                ArrayList<GeneralAccessor.ConditionTuple> tuples = new ArrayList<GeneralAccessor.ConditionTuple>();
                tuples.add(this.createValidCondition(true));
                GeneralAccessor.ConditionGroup group = GeneralAccessor.ConditionGroup.and((GeneralAccessor.ConditionGroup[])new GeneralAccessor.ConditionGroup[0]);
                tuples.forEach(arg_0 -> ((GeneralAccessor.ConditionGroup)group).add(arg_0));
                result = this.find(group, clazz);
            } else {
                result = this.template.findAll(clazz);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("List %d entity[%s].", result.size(), clazz.getName()));
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Class<T> clazz) {
        return this.list(clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Pagination pagination, Class<T> clazz) {
        return this.list(pagination, clazz, true);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> list(Pagination pagination, Class<T> clazz, boolean isValid) {
        if (pagination == null) {
            pagination = new Pagination();
        }
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            pagination.setTotal((int)this.count(clazz, isValid));
            int skip = (pagination.getPage() - 1) * pagination.getSize();
            int limit = pagination.getSize();
            List result = isValid ? this.template.find(Query.query((CriteriaDefinition)Criteria.where((String)"valid").is((Object)1)).skip((long)skip).limit(limit), clazz) : this.template.find(new Query().skip((long)skip).limit(limit), clazz);
            return result;
        }
        catch (ClassNotFoundException ex) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    @Transactional(readOnly=true)
    public <T extends PO> T getById(String id, Class<T> clazz) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            return (T)((PO)this.template.findById((Object)id, clazz));
        }
        catch (ClassNotFoundException ex) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    private Criteria createToupleCriteria(GeneralAccessor.ConditionTuple tuple) {
        switch (tuple.operate) {
            case FUZZY: {
                if (tuple.value instanceof Collection && ((Collection)tuple.value).size() > 1) {
                    return Criteria.where((String)tuple.field).regex(String.format(".*(%s).*", StringUtils.merge((Collection)((Collection)tuple.value), (String)"|")));
                }
                Object v = tuple.value instanceof Collection ? ((Collection)tuple.value).iterator().next() : tuple.value;
                return Criteria.where((String)tuple.field).regex(String.format(".*(%s).*", v.toString()));
            }
            case PREFIX: {
                return Criteria.where((String)tuple.field).regex(String.format("(%s).*", ((String)tuple.value).replaceAll(" ", " | ")));
            }
            case EQ: {
                return Criteria.where((String)tuple.field).is(tuple.value);
            }
            case LT: {
                return Criteria.where((String)tuple.field).lt(tuple.value);
            }
            case GT: {
                return Criteria.where((String)tuple.field).gt(tuple.value);
            }
            case LTE: {
                return Criteria.where((String)tuple.field).lte(tuple.value);
            }
            case GTE: {
                return Criteria.where((String)tuple.field).gte(tuple.value);
            }
            case IS_NULL: {
                return Criteria.where((String)tuple.field).exists(false);
            }
            case IS_NOT_NULL: {
                return Criteria.where((String)tuple.field).exists(true);
            }
            case IN: {
                if (tuple.value instanceof Collection) {
                    return Criteria.where((String)tuple.field).in((Collection)tuple.value);
                }
                return Criteria.where((String)tuple.field).is(tuple.value);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error(String.format("Unsupported the operate type: %s.", tuple.operate));
        }
        throw new UserInterfaceSystemErrorException(UserInterfaceSystemErrorException.SystemErrors.SYSTEM_UNSUPPORTED_OPERATE);
    }

    private Criteria createGroupCriteria(GeneralAccessor.ConditionGroup group) {
        Criteria criteria = new Criteria();
        if (group.getItems().size() == 1) {
            return this.createToupleCriteria((GeneralAccessor.ConditionTuple)group.getItems().get(0));
        }
        Criteria[] subCriterias = new Criteria[group.getItems().size()];
        for (int index = 0; index < group.getItems().size(); ++index) {
            subCriterias[index] = this.createGroupCriteria((GeneralAccessor.ConditionGroup)group.getItems().get(index));
        }
        if (group.getOperateType() == GeneralAccessor.ConditionGroup.OperateType.AND) {
            criteria.andOperator(subCriterias);
        } else {
            criteria.orOperator(subCriterias);
        }
        return criteria;
    }

    private Query withSortOrder(Query query, GeneralAccessor.RecordOrderGroup orderGroup) {
        if (orderGroup != null && !orderGroup.getOrders().isEmpty()) {
            ArrayList orders = new ArrayList();
            orderGroup.getOrders().forEach(order -> {
                if (order.getType() == GeneralAccessor.RecordOrder.OrderType.ASC) {
                    orders.add(Sort.Order.asc((String)order.getField()));
                } else {
                    orders.add(Sort.Order.desc((String)order.getField()));
                }
            });
            query.with(Sort.by(orders));
        }
        return query;
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> find(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        return this.find(null, group, null, clazz);
    }

    @Transactional(readOnly=true)
    public <T extends PO> List<T> find(Pagination pagination, GeneralAccessor.ConditionGroup group, GeneralAccessor.RecordOrderGroup orderGroup, Class<T> clazz) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            Query query = new Query();
            if (group != null && !group.getItems().isEmpty()) {
                query.addCriteria((CriteriaDefinition)this.createGroupCriteria(group));
            }
            if (pagination != null) {
                pagination.setTotal((int)this.template.count(query, clazz));
                query.skip((long)((pagination.getPage() - 1) * pagination.getSize()));
                query.limit(pagination.getSize());
            }
            query = this.withSortOrder(query, orderGroup);
            return this.template.find(query, clazz);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Condition find entity[%s] fail, condition: %s.", clazz.getName(), group), (Throwable)ex);
            }
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    @Transactional(readOnly=true)
    public <T extends PO> T findOne(GeneralAccessor.ConditionGroup group, Class<T> clazz) {
        List<T> list = this.find(group, clazz);
        if (list.isEmpty()) {
            return null;
        }
        return (T)((PO)list.get(0));
    }

    @Override
    @Transactional(readOnly=true)
    public <T extends Base> List<T> search(String content, boolean valid, Class<T> clazz) {
        return this.search(Collections.singletonList(content), valid, clazz);
    }

    @Override
    @Transactional(readOnly=true)
    public <T extends Base> List<T> search(List<String> contents, boolean valid, Class<T> clazz) {
        return this.search(null, contents, valid, clazz);
    }

    @Override
    @Transactional(readOnly=true)
    public <T extends Base> List<T> search(Pagination pagination, String content, boolean valid, Class<T> clazz) {
        return this.search(pagination, Collections.singletonList(content), valid, clazz);
    }

    @Override
    @Transactional(readOnly=true)
    public <T extends Base> List<T> search(Pagination pagination, List<String> contents, boolean valid, Class<T> clazz) {
        try {
            if (clazz.isInterface()) {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            TextQuery query = new TextQuery(new TextCriteria().matchingAny(contents.toArray(new String[0])));
            if (valid) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"valid").is((Object)1));
            }
            if (pagination != null) {
                pagination.setTotal((int)this.template.count((Query)query, clazz));
                query.skip((long)((pagination.getPage() - 1) * pagination.getSize()));
                query.limit(pagination.getSize());
            }
            return this.template.find((Query)query, clazz);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("Text search entity[%s] fail, condition: %s.", clazz.getName(), StringUtils.merge(contents, (String)",")), (Throwable)ex);
            }
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
        }
    }

    @Transactional
    public <T extends PO> T save(T t) {
        String parentId;
        super.prepareSave(t);
        this.template.save(t);
        if (t instanceof BaseDictTree && !StringUtils.isBlank((String)(parentId = ((BaseDictTree)t).getParentId()))) {
            PO parent = (PO)this.template.findById((Object)parentId, t.getClass());
            ((BaseDictTree)parent).getChildren().add((BaseDictTree)t);
            this.template.save((Object)parent);
        }
        String id = t.getId();
        t = (PO)this.template.findById((Object)id, t.getClass());
        return t;
    }

    private <T> Update toUpdate(T objectToSave, MongoWriter<T> writer) {
        Document doc = null;
        if (objectToSave instanceof Document) {
            doc = (Document)objectToSave;
        }
        if (!(objectToSave instanceof String)) {
            Document dbDoc = new Document();
            writer.write(objectToSave, (Object)dbDoc);
            if (dbDoc.containsKey((Object)ID_FIELD) && dbDoc.get((Object)ID_FIELD) == null) {
                dbDoc.remove((Object)ID_FIELD);
            }
            doc = dbDoc;
        } else {
            doc = Document.parse((String)((String)objectToSave));
        }
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(ID_FIELD, "_class"));
        Update update = new Update();
        for (String key : doc.keySet()) {
            if (excludes.contains(key)) continue;
            Object value = doc.get((Object)key);
            update.set(key, value);
        }
        return update;
    }

    @Transactional
    public <T extends PO> List<T> save(List<T> ts) {
        return this.save(ts, false);
    }

    private <T extends PO> List<T> save(List<T> ts, boolean logicRemove) {
        if (ts == null || ts.isEmpty()) {
            return ts;
        }
        BulkOperations bulk = this.template.bulkOps(BulkOperations.BulkMode.ORDERED, ((PO)ts.get(0)).getClass());
        for (PO t : ts) {
            BaseDictTree p;
            boolean isNew;
            if (logicRemove && t instanceof Base) {
                ((Base)t).setValid(0);
            }
            if (isNew = this.prepareSave(t)) {
                bulk.insert((Object)t);
            } else {
                bulk.updateOne(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)t.getId())), this.toUpdate((T)t, (MongoWriter<T>)this.template.getConverter()));
            }
            if (!(t instanceof BaseDictTree) || (p = ((BaseDictTree)t).getParent()) == null) continue;
            p.getChildren().add((BaseDictTree)t);
            bulk.updateOne(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)t.getId())), this.toUpdate((T)p, (MongoWriter<T>)this.template.getConverter()));
        }
        bulk.execute();
        return ts;
    }

    @Transactional
    public <T extends PO> void clear(Class<T> clazz) {
        if (clazz.isInterface()) {
            try {
                clazz = EntityFactory.getEntityClass(clazz);
            }
            catch (ClassNotFoundException ex) {
                throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INSTANCE_FAIL);
            }
        }
        this.template.remove(clazz).all();
    }

    @Transactional
    public <T extends PO> T remove(String id, Class<T> clazz) {
        return this.remove(id, clazz, true);
    }

    @Transactional
    public <T extends PO> T remove(String id, Class<T> clazz, boolean logicRemove) {
        T t = this.getById(id, clazz);
        if (t == null) {
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_NOT_FOUND);
        }
        return this.remove(t, logicRemove);
    }

    @Transactional
    public <T extends PO> T remove(T t) {
        return this.remove(t, true);
    }

    @Transactional
    public <T extends PO> T remove(T t, boolean logicRemove) {
        if (!(t instanceof Base)) {
            if (logger.isErrorEnabled()) {
                logger.error("The entity not implement Base interface.");
            }
            throw new UserInterfaceDalErrorException(UserInterfaceDalErrorException.DalErrors.ENTITY_INVALID_BASE);
        }
        if (logicRemove) {
            ((Base)t).setValid(0);
            t = this.save(t);
            return t;
        }
        this.template.remove(t);
        return t;
    }

    @Transactional
    public <T extends PO> List<T> remove(List<T> ts, boolean logicRemove) {
        if (ts == null || ts.isEmpty()) {
            return ts;
        }
        if (logicRemove) {
            return this.save(ts, true);
        }
        BulkOperations bulk = this.template.bulkOps(BulkOperations.BulkMode.ORDERED, ((PO)ts.get(0)).getClass());
        for (PO t : ts) {
            String id = t.getId();
            bulk.remove(new Query((CriteriaDefinition)Criteria.where((String)ID_FIELD).is((Object)id)));
        }
        bulk.execute();
        return ts;
    }
}

