/*
 * Decompiled with CFR 0.152.
 */
package org.mx.notify.processor;

import java.util.ArrayList;
import java.util.List;
import org.mx.StringUtils;
import org.mx.notify.config.NotifyServerConfigBean;
import org.mx.notify.error.UserInterfaceWsNotifyErrorException;
import org.mx.notify.processor.WsMessageProcessor;
import org.mx.service.server.websocket.WsConnectKey;
import org.mx.service.server.websocket.WsLifeCircleMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class NotifyServerWebSocket
extends WsLifeCircleMonitor {
    private static final Logger logger = LoggerFactory.getLogger(NotifyServerWebSocket.class);
    private ApplicationContext applicationContext;
    private NotifyServerConfigBean configBean;
    private List<WsMessageProcessor> processors;

    public NotifyServerWebSocket(ApplicationContext context, NotifyServerConfigBean configBean) {
        super(configBean.getNotifyPath());
        this.applicationContext = context;
        this.configBean = configBean;
    }

    public void init() {
        this.processors = new ArrayList<WsMessageProcessor>();
        String processorNames = this.configBean.getProcessorNames();
        for (String processorName : StringUtils.split((String)processorNames)) {
            WsMessageProcessor processor = (WsMessageProcessor)this.applicationContext.getBean(processorName, WsMessageProcessor.class);
            this.processors.add(processor);
            if (!logger.isInfoEnabled()) continue;
            logger.info(String.format("Load WebSocket processor['%s'] successed.", processorName));
        }
    }

    public void destroy() {
        this.processors.clear();
        this.processors = null;
    }

    public void hasText(WsConnectKey connectKey, String messageContext) {
        super.hasText(connectKey, messageContext);
        if (StringUtils.isBlank((String)messageContext)) {
            if (logger.isWarnEnabled()) {
                logger.warn("The text message is blank.");
            }
            throw new UserInterfaceWsNotifyErrorException(UserInterfaceWsNotifyErrorException.WsNotifyErrors.MESSAGE_BLANK);
        }
        for (WsMessageProcessor processor : this.processors) {
            WsMessageProcessor.ProcessedState state = processor.process(connectKey, messageContext);
            if (!this.configBean.isQuickMode() || state != WsMessageProcessor.ProcessedState.SUCCESS) continue;
            if (!logger.isTraceEnabled()) break;
            logger.trace("The message is processed success, and quick mode be set, process chain will be break.");
            break;
        }
    }
}

