/*
 * Decompiled with CFR 0.152.
 */
package org.mx.notify.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.mx.StringUtils;
import org.mx.service.server.websocket.WsConnectKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WsMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WsMessageProcessor.class);
    private String name;

    public WsMessageProcessor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isMatched(JSONObject var1);

    public abstract boolean isMatched(Document var1);

    public abstract boolean process(WsConnectKey var1, JSONObject var2);

    public abstract boolean process(WsConnectKey var1, Document var2);

    public ProcessedState process(WsConnectKey connectKey, String messageContext) {
        try {
            if (StringUtils.isJSON((String)messageContext)) {
                JSONObject json = JSON.parseObject((String)messageContext);
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("The message['%s'] is JSON.", messageContext));
                }
                if (!this.isMatched(json)) {
                    return ProcessedState.SKIPED;
                }
                boolean result = this.process(connectKey, json);
                if (result) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.format("The json message is processed success by %s.", this.name));
                    }
                    return ProcessedState.SUCCESS;
                }
                return ProcessedState.FAIL;
            }
            if (StringUtils.isXML((String)messageContext)) {
                Document xml = DocumentHelper.parseText((String)messageContext);
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("The message['%s'] is XML.", messageContext));
                }
                if (!this.isMatched(xml)) {
                    return ProcessedState.SKIPED;
                }
                boolean result = this.process(connectKey, xml);
                if (result) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.format("The xml message is processed success by %s.", this.name));
                    }
                    return ProcessedState.SUCCESS;
                }
                return ProcessedState.FAIL;
            }
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("The message['%s'] has invalid format, only for JSON or XML.", messageContext));
            }
            return ProcessedState.SKIPED;
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error(String.format("The message['%s'] from %s process fail.", connectKey.toString(), messageContext), (Throwable)ex);
            }
            return ProcessedState.FAIL;
        }
    }

    public static enum ProcessedState {
        SUCCESS,
        SKIPED,
        FAIL;

    }
}

