/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.capatcha;

import cn.hutool.core.codec.Base64;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import io.gitee.lglbc.easy.security.open.EasyLogin;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security"})
public class CaptchaController {
    private static final Logger log = LoggerFactory.getLogger(CaptchaController.class);
    @Autowired
    private DefaultKaptcha defaultKaptcha;
    @Autowired
    private EasyLogin easyLogin;

    public static String getBase64(BufferedImage image) {
        String base64 = null;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            base64 = "data:image/jpeg;base64," + Base64.encode((byte[])stream.toByteArray());
            log.info("\u751f\u6210\u7684\u56fe\u7247\u9a8c\u8bc1\u7801base64:{}", (Object)base64);
            stream.close();
        }
        catch (IOException e) {
            log.error("\u751f\u6210\u751f\u6210\u7684\u56fe\u7247\u9a8c\u8bc1\u7801base64\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return base64;
    }

    @GetMapping(value={"/captcha"})
    public Object captcha(HttpServletRequest request, HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String text = this.defaultKaptcha.createText();
        BufferedImage image = this.defaultKaptcha.createImage(text);
        return this.easyLogin.saveCaptcha(text, CaptchaController.getBase64(image));
    }
}

