/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.lglbc.easy.security.core.config.EasySecurityProperties;
import io.gitee.lglbc.easy.security.open.EasyLogin;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class EasyLoginFilter
extends UsernamePasswordAuthenticationFilter {
    @Autowired
    private EasySecurityProperties easySecurityProperties;
    @Autowired
    private EasyLogin easyLogin;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            Map map = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String userName = (String)map.get(this.getUsernameParameter());
            String passwd = (String)map.get(this.getPasswordParameter());
            if (this.easySecurityProperties.isCaptchaEnable()) {
                this.easyLogin.checkCaptcha(map);
            }
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)userName, (Object)passwd);
            return this.getAuthenticationManager().authenticate((Authentication)authenticationToken);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

