/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.security;

import io.gitee.lglbc.easy.security.core.config.EasySecurityProperties;
import io.gitee.lglbc.easy.security.core.security.EasyAuthenticationFilter;
import io.gitee.lglbc.easy.security.core.security.EasyLoginFilter;
import io.gitee.lglbc.easy.security.core.token.EasyPayload;
import io.gitee.lglbc.easy.security.core.token.TokenService;
import io.gitee.lglbc.easy.security.open.DefaultSecurityResultHandler;
import io.gitee.lglbc.easy.security.open.EasySecurityResultHandler;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableMethodSecurity
@EnableConfigurationProperties(value={EasySecurityProperties.class})
public class EasySecurityConfig {
    @Autowired
    private EasySecurityProperties easySecurityProperties;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private EasySecurityResultHandler easySecurityResultHandler;
    @Autowired
    private TokenService tokenService;
    private List<RequestMatcher> requestMatchers;

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> web.ignoring().requestMatchers(new RequestMatcher[]{request -> {
            for (RequestMatcher requestMatcher : this.requestMatchers) {
                if (!requestMatcher.matches(request)) continue;
                return true;
            }
            return false;
        }});
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/security/captcha"})).permitAll().anyRequest()).authenticated()).formLogin(form -> form.permitAll()).addFilterBefore((Filter)this.easyAuthenticationFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.easyLoginFilter(), EasyLoginFilter.class).exceptionHandling(handle -> {
            handle.accessDeniedHandler((request, response, accessDeniedException) -> this.easySecurityResultHandler.noPermissionHandler(request, response, accessDeniedException));
            handle.authenticationEntryPoint((request, response, authenticationException) -> this.easySecurityResultHandler.noPermissionHandler(request, response, authenticationException));
        }).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(csrf -> csrf.disable());
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService(this.userDetailsService);
        provider.setPasswordEncoder(this.passwordEncoder());
        return new ProviderManager(new AuthenticationProvider[]{provider});
    }

    @Bean
    public EasyLoginFilter easyLoginFilter() {
        EasyLoginFilter easyLoginFilter = new EasyLoginFilter();
        easyLoginFilter.setAuthenticationManager(this.authenticationManager());
        easyLoginFilter.setAuthenticationSuccessHandler(this.getSuccessHandler());
        easyLoginFilter.setAuthenticationFailureHandler(this.getFailureHandler());
        return easyLoginFilter;
    }

    @Bean
    public EasyAuthenticationFilter easyAuthenticationFilter() {
        return new EasyAuthenticationFilter();
    }

    protected AuthenticationFailureHandler getFailureHandler() {
        return (request, response, exception) -> this.easySecurityResultHandler.loginFailedHandler(request, response, exception);
    }

    private AuthenticationSuccessHandler getSuccessHandler() {
        return (request, response, authentication) -> {
            EasyPayload payloadDto = this.initPayload(authentication.getName(), authentication.getAuthorities());
            String token = this.tokenService.generateToken(payloadDto);
            this.easySecurityResultHandler.loginSuccessHandler(request, response, authentication, token);
        };
    }

    private EasyPayload initPayload(String user, Collection<? extends GrantedAuthority> authorities) {
        EasyPayload payloadDto = new EasyPayload();
        payloadDto.setUsername(user);
        if (!CollectionUtils.isEmpty(authorities)) {
            payloadDto.setAuthorities(authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()));
        }
        return payloadDto;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @PostConstruct
    public void init() {
        List<String> ignoreUrls = this.easySecurityProperties.getIgnoreUrls();
        if (CollectionUtils.isEmpty(ignoreUrls)) {
            ignoreUrls = new ArrayList<String>();
        }
        ignoreUrls.add("/security/captcha");
        this.requestMatchers = new ArrayList<RequestMatcher>();
        for (String pattern : ignoreUrls) {
            this.requestMatchers.add((RequestMatcher)new AntPathRequestMatcher(pattern, null));
        }
        if (this.easySecurityResultHandler == null) {
            this.easySecurityResultHandler = new DefaultSecurityResultHandler();
        }
    }
}

