/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.security;

import io.gitee.lglbc.easy.security.open.EasyLogin;
import io.gitee.lglbc.easy.security.open.SimpleUser;
import java.util.ArrayList;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class EasyUserDetailService
implements UserDetailsService {
    @Autowired
    private EasyLogin easyLogin;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        SimpleUser simpleUser = this.easyLogin.loadUser(username);
        if (Objects.isNull(simpleUser)) {
            throw new UsernameNotFoundException("user not found");
        }
        this.easyLogin.preCheck(simpleUser);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String role : simpleUser.getRoles()) {
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
        }
        for (String permission : simpleUser.getPermissions()) {
            authorities.add(new SimpleGrantedAuthority(permission));
        }
        return new User(username, simpleUser.getPassword(), authorities);
    }
}

