/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.token;

import com.alibaba.fastjson2.JSON;
import com.nimbusds.jose.jwk.RSAKey;
import io.gitee.lglbc.easy.security.core.config.EasyTokenProperties;
import io.gitee.lglbc.easy.security.core.token.EasyPayload;
import io.gitee.lglbc.easy.security.core.util.JwtTokenUtil;
import java.util.Date;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@EnableConfigurationProperties(value={EasyTokenProperties.class})
public class TokenService {
    @Autowired
    private EasyTokenProperties easyTokenProperties;

    public String generateToken(EasyPayload easyPayload) {
        Date now = new Date();
        Date exp = new Date(now.getTime() + (long)(this.easyTokenProperties.getExpireTime() * 1000));
        easyPayload.setSub(easyPayload.getUsername());
        easyPayload.setIat(now.getTime());
        easyPayload.setExp(exp.getTime());
        easyPayload.setJti(UUID.randomUUID().toString());
        String payloadStr = JSON.toJSONString((Object)easyPayload);
        if (this.easyTokenProperties.isEnableRSA()) {
            RSAKey rsaKey = JwtTokenUtil.getRSAKey(this.easyTokenProperties.getJksName(), this.easyTokenProperties.getJksSecret());
            return JwtTokenUtil.generateTokenByRSA(payloadStr, rsaKey);
        }
        return JwtTokenUtil.generateTokenByHMAC(payloadStr, this.easyTokenProperties.getSecret());
    }

    public EasyPayload checkToken(String token) {
        if (this.easyTokenProperties.isEnableRSA()) {
            RSAKey rsaKey = JwtTokenUtil.getRSAKey(this.easyTokenProperties.getJksName(), this.easyTokenProperties.getJksSecret());
            return JwtTokenUtil.checkTokenByRSA(token, rsaKey);
        }
        return JwtTokenUtil.checkTokenByHMAC(token, this.easyTokenProperties.getSecret());
    }
}

