/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.lglbc.easy.security.core.util;

import com.alibaba.fastjson2.JSON;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import io.gitee.lglbc.easy.security.core.exception.TokenException;
import io.gitee.lglbc.easy.security.core.token.EasyPayload;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.util.DigestUtils;

public class JwtTokenUtil {
    private static final String slat = "dafa#$%^&*()VBNM<>)(*&^%$%^&*()";

    public static String generateTokenByHMAC(String payloadStr, String secret) {
        JWSObject jwsObject = null;
        try {
            JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.HS256).type(JOSEObjectType.JWT).build();
            Payload payload = new Payload(payloadStr);
            jwsObject = new JWSObject(jwsHeader, payload);
            MACSigner jwsSigner = new MACSigner(JwtTokenUtil.md5(secret));
            jwsObject.sign((JWSSigner)jwsSigner);
        }
        catch (JOSEException e) {
            throw new TokenException("400", "token\u751f\u6210\u5931\u8d25!");
        }
        return jwsObject.serialize();
    }

    public static EasyPayload checkTokenByHMAC(String token, String secret) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            MACVerifier jwsVerifier = new MACVerifier(JwtTokenUtil.md5(secret));
            if (!jwsObject.verify((JWSVerifier)jwsVerifier)) {
                throw new TokenException("401", "token\u7b7e\u540d\u4e0d\u5408\u6cd5!");
            }
            String payload = jwsObject.getPayload().toString();
            EasyPayload payloadDto = (EasyPayload)JSON.parseObject((String)payload, EasyPayload.class);
            if (payloadDto.getExp() < new Date().getTime()) {
                throw new TokenException("402", "token\u5df2\u8fc7\u671f!");
            }
            return payloadDto;
        }
        catch (Exception e) {
            throw new TokenException("403", "token\u6821\u9a8c\u5931\u8d25!");
        }
    }

    public static String generateTokenByRSA(String payloadStr, RSAKey rsaKey) {
        JWSObject jwsObject = null;
        try {
            JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).build();
            Payload payload = new Payload(payloadStr);
            jwsObject = new JWSObject(jwsHeader, payload);
            RSASSASigner jwsSigner = new RSASSASigner(rsaKey, true);
            jwsObject.sign((JWSSigner)jwsSigner);
        }
        catch (JOSEException e) {
            throw new TokenException("400", "token verify failed");
        }
        return jwsObject.serialize();
    }

    public static EasyPayload checkTokenByRSA(String token, RSAKey rsaKey) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            RSAKey publicRsaKey = rsaKey.toPublicJWK();
            RSASSAVerifier jwsVerifier = new RSASSAVerifier(publicRsaKey);
            if (!jwsObject.verify((JWSVerifier)jwsVerifier)) {
                throw new TokenException("401", "token key is invalid");
            }
            String payload = jwsObject.getPayload().toString();
            EasyPayload payloadDto = (EasyPayload)JSON.parseObject((String)payload, EasyPayload.class);
            if (payloadDto.getExp() < new Date().getTime()) {
                throw new TokenException("402", "token expire");
            }
            return payloadDto;
        }
        catch (Exception e) {
            throw new TokenException("403", "token verify failed");
        }
    }

    public static RSAKey getRSAKey(String jksName, String jksSecret) {
        KeyStoreKeyFactory keyStoreKeyFactory = new KeyStoreKeyFactory((Resource)new ClassPathResource(jksName), jksSecret.toCharArray());
        KeyPair keyPair = keyStoreKeyFactory.getKeyPair("jwt", jksSecret.toCharArray());
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        return new RSAKey.Builder(publicKey).privateKey(privateKey).build();
    }

    public static String md5(String str) {
        String base = str + "/dafa#$%^&*()VBNM<>)(*&^%$%^&*()";
        String md5 = DigestUtils.md5DigestAsHex((byte[])base.getBytes());
        return md5;
    }
}

